/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingEvent;

public class ColorHelper {
    public static final boolean isFullyTransparent(int argb) {
        return (argb >> 16 & 0xFF) == 0;
    }

    public static final int opaque(int argb) {
        return 0xFF000000 | argb & 0xFFFFFF;
    }

    public static final int copyAlpha(int rgb, int a) {
        return a & 0xFF000000 | rgb & 0xFFFFFF;
    }

    public static final Vec3 toOKLabVec(int argb) {
        int r8 = argb >> 16 & 0xFF;
        int g8 = argb >> 8 & 0xFF;
        int b8 = argb & 0xFF;
        double r = ColorHelper.srgbToLinear((double)r8 / 255.0);
        double g = ColorHelper.srgbToLinear((double)g8 / 255.0);
        double b = ColorHelper.srgbToLinear((double)b8 / 255.0);
        double l = 0.4122214708 * r + 0.5363325363 * g + 0.0514459929 * b;
        double m = 0.2119034982 * r + 0.6806995451 * g + 0.1073969566 * b;
        double s = 0.0883024619 * r + 0.2817188376 * g + 0.6299787005 * b;
        double l_ = Math.cbrt(l);
        double m_ = Math.cbrt(m);
        double s_ = Math.cbrt(s);
        double L = 0.2104542553 * l_ + 0.793617785 * m_ - 0.0040720468 * s_;
        double A = 1.9779984951 * l_ - 2.428592205 * m_ + 0.4505937099 * s_;
        double B = 0.0259040371 * l_ + 0.7827717662 * m_ - 0.808675766 * s_;
        return new Vec3(L, A, B);
    }

    public static final double srgbToLinear(double c) {
        return c <= 0.04045 ? c / 12.92 : Math.pow((c + 0.055) / 1.055, 2.4);
    }

    public static final int toRGB(Vec3 OKLabVec) {
        double L = OKLabVec.x;
        double A = OKLabVec.y;
        double B = OKLabVec.z;
        double l_ = L + 0.3963377774 * A + 0.2158037573 * B;
        double m_ = L - 0.1055613458 * A - 0.0638541728 * B;
        double s_ = L - 0.0894841775 * A - 1.291485548 * B;
        double l = l_ * l_ * l_;
        double m = m_ * m_ * m_;
        double s = s_ * s_ * s_;
        double r = 4.0767416621 * l - 3.3077115913 * m + 0.2309699292 * s;
        double g = -1.2684380046 * l + 2.6097574011 * m - 0.3413193965 * s;
        double b = -0.0041960863 * l - 0.7034186147 * m + 1.707614701 * s;
        int r8 = Mth.clamp((int)((int)Math.round(ColorHelper.linearToSrgb(r) * 255.0)), (int)0, (int)255);
        int g8 = Mth.clamp((int)((int)Math.round(ColorHelper.linearToSrgb(g) * 255.0)), (int)0, (int)255);
        int b8 = Mth.clamp((int)((int)Math.round(ColorHelper.linearToSrgb(b) * 255.0)), (int)0, (int)255);
        return 0xFF000000 | r8 << 16 | g8 << 8 | b8;
    }

    public static final double linearToSrgb(double c) {
        return c <= 0.0031308 ? 12.92 * c : 1.055 * Math.pow(c, 0.4166666666666667) - 0.055;
    }

    @Nullable
    public static final DyeColor getColor(LivingEntity entity) {
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            return sheep.getColor();
        }
        if (entity instanceof Shulker) {
            Shulker shulker = (Shulker)entity;
            return shulker.getColor();
        }
        EntityColorEvent event = new EntityColorEvent(entity);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getColor();
    }

    public static final class EntityColorEvent
    extends LivingEvent {
        @Nullable
        protected DyeColor color;

        public EntityColorEvent(LivingEntity entity) {
            super(entity);
        }

        public void setColor(@Nullable DyeColor color) {
            this.color = color;
        }

        @Nullable
        public DyeColor getColor() {
            return this.color;
        }
    }
}

