/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import com.petrolpark.core.fluid.FluidMixer;
import com.petrolpark.util.DataComponentHelper;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidHelper {
    public static boolean equalIgnoringComponents(FluidStack stack1, FluidStack stack2, DataComponentType<?> ... ignoredComponentTypes) {
        if (stack1.getFluid() != stack2.getFluid()) {
            return false;
        }
        return DataComponentHelper.equalIgnoring((DataComponentMap)stack1.getComponents(), (DataComponentMap)stack2.getComponents(), type -> Stream.of(ignoredComponentTypes).anyMatch(arg_0 -> ((DataComponentType)type).equals(arg_0)));
    }

    public static int fillTankWithMixer(RegistryAccess registryAccess, FluidTank tank, FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !tank.isFluidValid(resource)) {
            return 0;
        }
        FluidStack toAdd = resource.copy();
        FluidStack result = FluidMixer.mixIn(registryAccess, tank.getFluid(), toAdd, tank.getCapacity(), action);
        if (action.execute()) {
            tank.setFluid(result);
        }
        return toAdd.getAmount();
    }
}

