/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Rotation;

public record HorizontalBlockPos(int x, int z) {
    public static final Codec<HorizontalBlockPos> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(HorizontalBlockPos::x), (App)Codec.INT.fieldOf("z").forGetter(HorizontalBlockPos::z)).apply((Applicative)instance, HorizontalBlockPos::new));
    public static final StreamCodec<ByteBuf, HorizontalBlockPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, HorizontalBlockPos::x, (StreamCodec)ByteBufCodecs.INT, HorizontalBlockPos::z, HorizontalBlockPos::new);

    public static HorizontalBlockPos of(BlockPos pos) {
        return new HorizontalBlockPos(pos.getX(), pos.getZ());
    }

    public boolean is(BlockPos pos) {
        return pos.getX() == this.x() && pos.getZ() == this.z();
    }

    public HorizontalBlockPos offset(int x, int z) {
        return new HorizontalBlockPos(this.x() + x, this.z() + z);
    }

    public HorizontalBlockPos offset(HorizontalBlockPos vector) {
        return this.offset(vector.x(), vector.z());
    }

    public HorizontalBlockPos subtract(HorizontalBlockPos vector) {
        return this.offset(-vector.x(), -vector.z());
    }

    public HorizontalBlockPos multiply(int scalar) {
        return new HorizontalBlockPos(this.x() * scalar, this.z() * scalar);
    }

    public HorizontalBlockPos north() {
        return this.relative(Direction.NORTH);
    }

    public HorizontalBlockPos north(int distance) {
        return this.relative(Direction.NORTH, distance);
    }

    public HorizontalBlockPos south() {
        return this.relative(Direction.SOUTH);
    }

    public HorizontalBlockPos south(int distance) {
        return this.relative(Direction.SOUTH, distance);
    }

    public HorizontalBlockPos west() {
        return this.relative(Direction.WEST);
    }

    public HorizontalBlockPos west(int distance) {
        return this.relative(Direction.WEST, distance);
    }

    public HorizontalBlockPos east() {
        return this.relative(Direction.EAST);
    }

    public HorizontalBlockPos east(int distance) {
        return this.relative(Direction.EAST, distance);
    }

    public HorizontalBlockPos relative(Direction direction) {
        return this.relative(direction, 1);
    }

    public HorizontalBlockPos relative(Direction direction, int distance) {
        if (direction.getAxis() == Direction.Axis.Y) {
            throw new IllegalArgumentException("Cannot offset HorizontalBlockPos vertically");
        }
        return distance == 0 ? this : new HorizontalBlockPos(this.x() + direction.getStepX() * distance, this.z() + direction.getStepZ() * distance);
    }

    public HorizontalBlockPos rotate(Rotation rotation) {
        switch (rotation) {
            default: {
                return this;
            }
            case CLOCKWISE_90: {
                return new HorizontalBlockPos(-this.z(), this.x());
            }
            case CLOCKWISE_180: {
                return new HorizontalBlockPos(-this.x(), -this.z());
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new HorizontalBlockPos(this.z(), -this.x());
    }

    public int distanceToSqr(HorizontalBlockPos pos) {
        return (this.x() - pos.x()) * (this.x() - pos.x()) + (this.z() - pos.z()) * (this.z() - pos.z());
    }

    public Optional<HorizontalBlockPos> closest(Collection<HorizontalBlockPos> otherPositions) {
        return otherPositions.stream().min(Comparator.comparingInt(this::distanceToSqr));
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HorizontalBlockPos) {
            HorizontalBlockPos pos = (HorizontalBlockPos)obj;
            return this.x() == pos.x() && this.z == pos.z();
        }
        return false;
    }
}

