/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MathsHelper {
    public static final int floorLog(int x, int base) {
        int result = 0;
        while (x >= base) {
            x /= base;
            ++result;
        }
        return result;
    }

    public static int exponentiate(int base, int exponent) {
        int result = 1;
        while (exponent > 0) {
            if ((exponent & 1) == 1) {
                result *= base;
            }
            base *= base;
            exponent >>= 1;
        }
        return result;
    }

    public static double angleBetween(Vec3 vec1, Vec3 vec2, Vec3 plane) {
        double angle = Math.acos(vec1.dot(vec2) / (vec1.length() * vec2.length())) * 180.0 / 3.1415927410125732;
        if (vec1.dot(vec2.cross(plane)) < 0.0) {
            angle = 360.0 - angle;
        }
        return angle;
    }

    public static Vec3 rotate(Vec3 vec, Vec3 rotationAxis, double angle) {
        Vec3 k = rotationAxis.normalize();
        double angleInRads = angle * 3.1415927410125732 / 180.0;
        return vec.scale(Math.cos(angleInRads)).add(k.cross(vec).scale(Math.sin(angleInRads))).add(k.scale(k.dot(vec) * (1.0 - Math.cos(angleInRads))));
    }

    public static Vec3i add(Vec3i vec1, Vec3i vec2) {
        return new Vec3i(vec1.getX() + vec2.getX(), vec1.getY() + vec2.getY(), vec1.getZ() + vec2.getZ());
    }

    public static Comparator<Vec3> getClosest(Vec3 targetVector) {
        return (v1, v2) -> Double.compare(v1.dot(targetVector), v2.dot(targetVector));
    }

    public static double azimuth(Vec3 vec) {
        return Math.atan2(vec.x, vec.z);
    }

    public static double inclination(Vec3 vec) {
        return Math.atan2(Math.sqrt(vec.x() * vec.x() + vec.z() * vec.z()), vec.y());
    }

    public static AABB expandToInclude(AABB box, Vec3 point) {
        return new AABB(Math.min(box.minX, point.x), Math.min(box.minY, point.y), Math.min(box.minZ, point.z), Math.max(box.maxX, point.x), Math.max(box.maxY, point.y), Math.max(box.maxZ, point.z));
    }

    public static AABB expandToInclude(AABB box, BlockPos pos) {
        return MathsHelper.expandToInclude(MathsHelper.expandToInclude(box, Vec3.atLowerCornerOf((Vec3i)pos)), Vec3.atLowerCornerOf((Vec3i)pos).add(1.0, 1.0, 1.0));
    }

    public static double volume(AABB box) {
        return (box.maxX - box.minX) * (box.maxY - box.minY) * (box.maxZ - box.minZ);
    }
}

