/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.util.BinaryMatrix4x4;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class NBTHelper {
    public static boolean equalIgnoring(CompoundTag tag1, CompoundTag tag2, String ... ignoredKeys) {
        if (tag1 == tag2) {
            return true;
        }
        HashSet<String> checkedKeys = new HashSet<String>();
        if (tag1 != null) {
            block0: for (String key : tag1.getAllKeys()) {
                checkedKeys.add(key);
                for (String ignoredKey : ignoredKeys) {
                    if (key.equals(ignoredKey)) continue block0;
                }
                if (tag2 != null && Objects.equals(tag1.get(key), tag2.get(key))) continue;
                return false;
            }
        }
        if (tag2 != null) {
            block2: for (String key : tag2.getAllKeys()) {
                if (checkedKeys.contains(key)) continue;
                for (String ignoredKey : ignoredKeys) {
                    if (key.equals(ignoredKey)) continue block2;
                }
                if (tag1 != null && Objects.equals(tag1.get(key), tag2.get(key))) continue;
                return false;
            }
        }
        return true;
    }

    public static Consumer<Tag> writeAt(CompoundTag tag, String key) {
        return t -> tag.put(key, t);
    }

    public static <T> List<T> readCompoundList(ListTag tag, Function<CompoundTag, T> reader) {
        return tag.stream().map(CompoundTag.class::cast).map(reader).collect(Collectors.toList());
    }

    public static <T> ListTag writeCompoundList(List<T> list, Function<T, CompoundTag> writer) {
        ListTag tag = new ListTag();
        list.stream().map(writer).forEach(arg_0 -> tag.add(arg_0));
        return tag;
    }

    public static <E extends Enum<E>> E readEnum(CompoundTag tag, String key, Class<E> enumClass) {
        return (E)((Enum[])enumClass.getEnumConstants())[tag.getInt(key)];
    }

    public static <E extends Enum<E>> void writeEnum(CompoundTag tag, String key, E enumValue) {
        tag.putInt(key, enumValue.ordinal());
    }

    public static Vec3 readVec3(ListTag tag, BlockPos origin) {
        return Vec3.atLowerCornerOf((Vec3i)origin).add(tag.getDouble(0), tag.getDouble(1), tag.getDouble(2));
    }

    public static ListTag writeVec3(Vec3 vec, BlockPos origin) {
        vec = vec.subtract(Vec3.atLowerCornerOf((Vec3i)origin));
        ListTag tag = new ListTag();
        tag.add((Object)DoubleTag.valueOf((double)vec.x()));
        tag.add((Object)DoubleTag.valueOf((double)vec.y()));
        tag.add((Object)DoubleTag.valueOf((double)vec.z()));
        return tag;
    }

    @Deprecated
    public static int readBogglePattern(CompoundTag tag, String key) {
        if (!tag.contains(key, 2)) {
            return 0;
        }
        return BinaryMatrix4x4.fromShort(tag.getShort(key));
    }

    @Deprecated
    public static void writeBogglePattern(CompoundTag tag, String key, int binaryMatrix) {
        tag.putShort(key, BinaryMatrix4x4.asShort(binaryMatrix));
    }

    public static <OBJECT> OBJECT readRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey, Level level) {
        return NBTHelper.readRegistryObject(tag, key, registryKey, level.registryAccess());
    }

    public static <OBJECT> void writeRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey, Level level, OBJECT object) {
        NBTHelper.writeRegistryObject(tag, key, registryKey, level.registryAccess(), object);
    }

    public static <OBJECT> OBJECT readRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey, RegistryAccess registryAccess) {
        return (OBJECT)registryAccess.registryOrThrow(registryKey).get(ResourceLocation.parse((String)tag.getString(key)));
    }

    public static <OBJECT> void writeRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey, RegistryAccess registryAccess, OBJECT object) {
        ResourceLocation rl = registryAccess.registryOrThrow(registryKey).getKey(object);
        if (rl != null) {
            tag.putString(key, rl.toString());
        }
    }

    public static <OBJECT> OBJECT readRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey) {
        return (OBJECT)PetrolparkRegistries.getRegistry(registryKey).orElseThrow(NBTHelper::registryNotLoadedException).get(ResourceLocation.parse((String)tag.getString(key)));
    }

    public static <OBJECT> void writeRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> registryKey, OBJECT object) {
        ResourceLocation rl = PetrolparkRegistries.getRegistry(registryKey).orElseThrow(NBTHelper::registryNotLoadedException).getKey(object);
        if (rl != null) {
            tag.putString(key, rl.toString());
        }
    }

    public static <OBJECT> OBJECT readDataRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> dataRegistryKey) {
        return (OBJECT)PetrolparkRegistries.getRegistry(dataRegistryKey).orElseThrow(NBTHelper::registryNotLoadedException).get(ResourceLocation.parse((String)tag.getString(key)));
    }

    public static <OBJECT> void writeDataRegistryObject(CompoundTag tag, String key, ResourceKey<Registry<OBJECT>> dataRegistryKey, OBJECT dataObject) {
        ResourceLocation rl = PetrolparkRegistries.getRegistry(dataRegistryKey).orElseThrow(NBTHelper::registryNotLoadedException).getKey(dataObject);
        if (rl != null) {
            tag.putString(key, rl.toString());
        }
    }

    public static IllegalStateException registryNotLoadedException() {
        return new IllegalStateException("Registries have not been loaded yet");
    }
}

