/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.client.creativemodetab;

import com.google.common.collect.ImmutableList;
import com.petrolpark.client.rendering.PetrolparkGuiTexture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public class CustomTab
extends CreativeModeTab {
    public final ImmutableList<ITabEntry> entries;
    public final Map<Integer, ITabEntry> renderedEntries;

    protected CustomTab(Builder builder) {
        super((CreativeModeTab.Builder)builder);
        this.entries = ImmutableList.copyOf(builder.entries);
        this.renderedEntries = new HashMap<Integer, ITabEntry>();
    }

    public void buildContents(@Nonnull CreativeModeTab.ItemDisplayParameters parameters) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(this.entries.size());
        this.displayItemsSearchTab = new HashSet(this.entries.size());
        for (ITabEntry entry : this.entries) {
            entry.addItems(items, parameters, i -> this.renderedEntries.put(i, entry));
            this.displayItemsSearchTab.addAll(entry.getItemsToAddToSearch(parameters));
        }
        this.displayItems = items;
    }

    public static class Builder
    extends CreativeModeTab.Builder {
        public final List<ITabEntry> entries = new ArrayList<ITabEntry>();

        public Builder(CreativeModeTab.Row row, int column) {
            super(row, column);
            this.withTabFactory(b -> {
                if (!(b instanceof Builder)) {
                    throw new IllegalArgumentException("Supplied builder must extend CustomTab.Builder");
                }
                Builder cb = (Builder)((Object)b);
                return new CustomTab(cb);
            });
        }

        public Builder add(ITabEntry ... entries) {
            for (ITabEntry entry : entries) {
                this.entries.add(entry);
            }
            return this;
        }

        @Deprecated
        public Builder displayItems(@Nonnull CreativeModeTab.DisplayItemsGenerator displayItemsGenerator) {
            return this;
        }
    }

    public static interface ITabEntry {
        public static final ITabEntry EMPTY = new ITabEntry(){};
        public static final ITabEntry LINE_BREAK = new ITabEntry(){

            @Override
            public int getSize() {
                return 0;
            }

            @Override
            public boolean newLine() {
                return true;
            }
        };

        default public int getSize() {
            return 1;
        }

        default public boolean newLine() {
            return false;
        }

        default public void addItems(List<ItemStack> stacks, CreativeModeTab.ItemDisplayParameters parameters, IntConsumer specialRenderLocation) {
            if (this.newLine()) {
                stacks.addAll(Collections.nCopies((9 - stacks.size() % 9) % 9, ItemStack.EMPTY));
            }
            if (this.hasSpecialRendering()) {
                specialRenderLocation.accept(stacks.size());
            }
            stacks.addAll(Collections.nCopies(this.getSize(), ItemStack.EMPTY));
        }

        default public boolean hasSpecialRendering() {
            return false;
        }

        default public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        }

        default public Collection<ItemStack> getItemsToAddToSearch(CreativeModeTab.ItemDisplayParameters parameters) {
            return Collections.emptyList();
        }

        public static class Subheading
        implements ITabEntry {
            public final Component subheading;

            public Subheading(Component subheading) {
                this.subheading = subheading;
            }

            @Override
            public int getSize() {
                return 9;
            }

            @Override
            public boolean newLine() {
                return true;
            }

            @Override
            public boolean hasSpecialRendering() {
                return true;
            }

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.getInstance();
                PetrolparkGuiTexture.CREATIVE_MODE_TAB_BLANK_ROW.render(graphics, 0, 0);
                graphics.drawString(mc.font, this.subheading, 3, 5, 0x5A575A, false);
            }
        }

        public static class DuplicateItem
        extends Item {
            public DuplicateItem(Supplier<ItemStack> stack) {
                super(stack);
            }

            @Override
            public Collection<ItemStack> getItemsToAddToSearch(CreativeModeTab.ItemDisplayParameters parameters) {
                return Collections.emptyList();
            }
        }

        public static class ConditionalItem
        extends Item {
            public final Supplier<Boolean> condition;

            public ConditionalItem(Supplier<ItemStack> stack, Supplier<Boolean> condition) {
                super(stack);
                this.condition = condition;
            }

            @Override
            public void addItems(List<ItemStack> stacks, CreativeModeTab.ItemDisplayParameters parameters, IntConsumer specialRenderLocation) {
                if (this.condition.get().booleanValue()) {
                    super.addItems(stacks, parameters, specialRenderLocation);
                }
            }

            @Override
            public Collection<ItemStack> getItemsToAddToSearch(CreativeModeTab.ItemDisplayParameters parameters) {
                if (!this.condition.get().booleanValue()) {
                    return Collections.emptySet();
                }
                return super.getItemsToAddToSearch(parameters);
            }
        }

        public static class Item
        implements ITabEntry {
            public final Supplier<ItemStack> stack;

            public Item(Supplier<ItemStack> stack) {
                this.stack = stack;
            }

            @Override
            public void addItems(List<ItemStack> stacks, CreativeModeTab.ItemDisplayParameters parameters, IntConsumer specialRenderLocation) {
                stacks.add(this.stack.get());
            }

            @Override
            public Collection<ItemStack> getItemsToAddToSearch(CreativeModeTab.ItemDisplayParameters parameters) {
                return Collections.singleton(this.stack.get());
            }
        }
    }
}

