/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.client.sprite;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.client.sprite.WrappedSpriteSource;
import com.petrolpark.util.ColorHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.world.phys.Vec3;

public class MeanShiftClusterSpriteSource
extends WrappedSpriteSource {
    public static final MapCodec<MeanShiftClusterSpriteSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SpriteSources.CODEC.fieldOf("source").forGetter(WrappedSpriteSource::getWrappedSource), (App)Codec.STRING.optionalFieldOf("prefix", (Object)"").forGetter(WrappedSpriteSource::getPrefix), (App)Codec.STRING.listOf().optionalFieldOf("allowed_namespaces").forGetter(WrappedSpriteSource::getAllowedNamespaces), (App)Codec.intRange((int)0, (int)1024).optionalFieldOf("max_iterations", (Object)20).forGetter(MeanShiftClusterSpriteSource::getMaxIterations), (App)Codec.doubleRange((double)0.0, (double)1024.0).optionalFieldOf("bandwidth_coefficient", (Object)1.0).forGetter(MeanShiftClusterSpriteSource::getBandwidthCoefficient), (App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("bandwidth_variation_exponent", (Object)0.5).forGetter(MeanShiftClusterSpriteSource::getBandwidthVariationExponent), (App)Codec.doubleRange((double)-1.0, (double)0.0).optionalFieldOf("bandwidth_sample_size_exponent", (Object)-0.142857142857).forGetter(MeanShiftClusterSpriteSource::getBandwidthSampleSizeExponent)).apply((Applicative)instance, MeanShiftClusterSpriteSource::new));
    public static final SpriteSourceType TYPE = new SpriteSourceType(CODEC);
    private final int maxIterations;
    private final double bandwidthCoefficient;
    private final double bandwidthVariationExponent;
    private final double bandwidthSampleSizeExponent;

    public MeanShiftClusterSpriteSource(SpriteSource wrappedSource, String prefix, Optional<List<String>> allowedNamespaces, int maxIterations, double bandwidthCoefficient, double bandwidthVariationExponent, double bandwidthSampleSizeExponent) {
        super(wrappedSource, prefix, allowedNamespaces);
        this.maxIterations = maxIterations;
        this.bandwidthCoefficient = bandwidthCoefficient;
        this.bandwidthVariationExponent = bandwidthVariationExponent;
        this.bandwidthSampleSizeExponent = bandwidthSampleSizeExponent;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public double getBandwidthCoefficient() {
        return this.bandwidthCoefficient;
    }

    public double getBandwidthVariationExponent() {
        return this.bandwidthVariationExponent;
    }

    public double getBandwidthSampleSizeExponent() {
        return this.bandwidthSampleSizeExponent;
    }

    @Override
    public SpriteSource.SpriteSupplier transform(final SpriteContents original) {
        final NativeImage originalImage = original.getOriginalImage();
        HashMap<Integer, Integer> weightedColors = new HashMap<Integer, Integer>();
        for (int color2 : originalImage.getPixelsRGBA()) {
            if (ColorHelper.isFullyTransparent(color2)) continue;
            weightedColors.merge(ColorHelper.opaque(color2), 1, Integer::sum);
        }
        Map<Integer, Vec3> OKLabcolors = weightedColors.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ColorHelper.toOKLabVec((Integer)e.getKey())));
        Vec3 totalColor = Vec3.ZERO;
        int totalWeight = 0;
        for (Map.Entry weightedColor : weightedColors.entrySet()) {
            totalColor = totalColor.add(OKLabcolors.get(weightedColor.getKey()).scale((double)((Integer)weightedColor.getValue()).intValue()));
            totalWeight += ((Integer)weightedColor.getValue()).intValue();
        }
        Vec3 meanColor = totalColor.scale(1.0 / (double)totalWeight);
        final int meanColorRGB = ColorHelper.toRGB(meanColor);
        double sumSquares = 0.0;
        for (Vec3 color3 : OKLabcolors.values()) {
            sumSquares += color3.distanceToSqr(meanColor);
        }
        double variance = sumSquares / (double)totalWeight;
        double bandwidth = this.bandwidthCoefficient * Math.pow(variance, this.bandwidthVariationExponent) * Math.pow(totalWeight, this.bandwidthSampleSizeExponent);
        double bandwidthSquare = bandwidth * bandwidth;
        HashSet visitedColors = new HashSet(weightedColors.size());
        final HashMap colorMap = new HashMap(weightedColors.size());
        while (visitedColors.size() < weightedColors.size()) {
            for (Map.Entry startWeightedColor : weightedColors.entrySet()) {
                if (visitedColors.contains(startWeightedColor.getKey())) continue;
                Vec3 clusterCenter = ColorHelper.toOKLabVec((Integer)startWeightedColor.getKey());
                HashSet<Integer> includedColors = new HashSet<Integer>();
                for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
                    Vec3 oldClusterCenter;
                    includedColors.clear();
                    Vec3 totalClusterColor = Vec3.ZERO;
                    int totalClusterWeight = 0;
                    for (Map.Entry weightedColor : weightedColors.entrySet()) {
                        Vec3 color4 = ColorHelper.toOKLabVec((Integer)weightedColor.getKey());
                        if (clusterCenter.distanceToSqr(color4) > bandwidthSquare || visitedColors.contains(weightedColor.getKey())) continue;
                        includedColors.add((Integer)weightedColor.getKey());
                        int weight = (Integer)weightedColor.getValue();
                        totalClusterColor = totalClusterColor.add(color4.scale((double)weight));
                        totalClusterWeight += weight;
                    }
                    if (totalClusterWeight > 0 && (oldClusterCenter = clusterCenter).distanceToSqr(clusterCenter = totalClusterColor.scale(1.0 / (double)totalClusterWeight)) < 0.00392156862745098) break;
                }
                int clusterCenterRGB = ColorHelper.toRGB(clusterCenter);
                includedColors.forEach(color -> colorMap.put(color, clusterCenterRGB));
                visitedColors.addAll(includedColors);
            }
        }
        return new SpriteSource.SpriteSupplier(){

            public SpriteContents apply(SpriteResourceLoader resourceLoader) {
                return new SpriteContents(original.name(), new FrameSize(original.width(), original.height()), originalImage.mappedCopy(originalARGB -> {
                    if (ColorHelper.isFullyTransparent(originalARGB)) {
                        return originalARGB;
                    }
                    Integer mappedColorRGB = (Integer)colorMap.get(ColorHelper.opaque(originalARGB));
                    if (mappedColorRGB == null) {
                        mappedColorRGB = meanColorRGB;
                    }
                    return ColorHelper.copyAlpha(mappedColorRGB, originalARGB);
                }), original.metadata());
            }

            public void discard() {
                originalImage.close();
            }
        };
    }

    public SpriteSourceType type() {
        return TYPE;
    }
}

