/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat;

import com.google.common.base.Strings;
import com.petrolpark.PetrolparkRegistrate;
import com.petrolpark.util.Lang;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.language.IModInfo;

public enum Mods {
    CREATE,
    PETROLPARK,
    ACADEMY,
    CREATE_BISTRO("createbistro"),
    DESTROY,
    PETROLS_PARTS("petrolsparts"),
    PQUALITY,
    BIG_CANNONS("createbigcannons"),
    CURIOS,
    JEI,
    TFMG;

    public final String id;
    private PetrolparkRegistrate registrate;

    private Mods() {
        this.id = Lang.asId(this.name());
    }

    private Mods(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return ModList.get().getModContainerById(this.id).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).filter(Predicate.not(Strings::isNullOrEmpty)).orElse("Unknown");
    }

    public static boolean isLoading(String modid) {
        return FMLLoader.getLoadingModList().getModFileById(modid) != null;
    }

    public boolean isLoading() {
        return Mods.isLoading(this.id);
    }

    public boolean isLoaded() {
        return ModList.get().isLoaded(this.id);
    }

    public void executeIfInstalled(Supplier<Runnable> toExecute) {
        if (this.isLoaded()) {
            toExecute.get().run();
        }
    }

    public ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.id, (String)path);
    }

    public PetrolparkRegistrate registrate() {
        if (this.registrate == null) {
            this.registrate = new PetrolparkRegistrate(this.id);
        }
        return this.registrate;
    }
}

