/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.processing.extrusion;

import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.EmptyModel;
import net.neoforged.neoforge.client.model.data.ModelData;

public class ExtrudedBlockModel
extends CopycatModel {
    protected static final AABB CUBE_AABB = new AABB(BlockPos.ZERO);
    private final BlockState extrusionResult;
    private final Direction movementDirection;
    private final float progress;

    public ExtrudedBlockModel(BlockState extrusionResult, Direction movementDirection, float progress) {
        super(EmptyModel.BAKED);
        this.extrusionResult = extrusionResult;
        this.movementDirection = movementDirection;
        this.progress = progress;
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        return super.gatherModelData(builder, world, pos, state, blockEntityData).with(MATERIAL_PROPERTY, (Object)this.extrusionResult);
    }

    protected List<BakedQuad> getCroppedQuads(BlockState state, Direction side, RandomSource rand, BlockState material, ModelData wrappedData, RenderType renderType) {
        BakedModel model = ExtrudedBlockModel.getModelOf((BlockState)this.extrusionResult);
        List templateQuads = model.getQuads(this.extrusionResult, side, rand, wrappedData, renderType);
        int size = templateQuads.size();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)this.movementDirection.getOpposite().getNormal());
        AABB bb = CUBE_AABB.contract(normal.x * (double)this.progress, normal.y * (double)this.progress, normal.z * (double)this.progress);
        for (int i = 0; i < size; ++i) {
            BakedQuad quad = (BakedQuad)templateQuads.get(i);
            quads.add(BakedQuadHelper.cloneWithCustomGeometry((BakedQuad)quad, (int[])ExtrudedBlockModel.scale(BakedModelHelper.cropAndMove((int[])quad.getVertices(), (TextureAtlasSprite)quad.getSprite(), (AABB)bb, (Vec3)Vec3.ZERO), 1.01f)));
        }
        return quads;
    }

    public static int[] scale(int[] vertexData, float factor) {
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        for (int vertex = 0; vertex < 4; ++vertex) {
            Vec3 xyz = BakedQuadHelper.getXYZ((int[])vertexData, (int)vertex);
            BakedQuadHelper.setXYZ((int[])vertexData, (int)vertex, (Vec3)xyz.subtract(0.5, 0.5, 0.5).scale((double)factor).add(0.5, 0.5, 0.5));
        }
        return vertexData;
    }
}

