/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.block.entity.behaviour;

import com.petrolpark.RequiresCreate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ConcurrentModificationException;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@RequiresCreate
public abstract class AbstractRememberPlacerBehaviour
extends BlockEntityBehaviour {
    private UUID playerUUID;

    @SubscribeEvent
    public static void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity player = (LivingEntity)entity;
            AbstractRememberPlacerBehaviour.setPlacedBy(player.level(), event.getPos(), player);
        }
    }

    public AbstractRememberPlacerBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public abstract boolean shouldRememberPlacer(Player var1);

    @Nullable
    public Player getPlayer() {
        if (this.playerUUID == null) {
            return null;
        }
        return this.getWorld().getPlayerByUUID(this.playerUUID);
    }

    public void setPlayer(UUID uuid) {
        Player player = this.getWorld().getPlayerByUUID(uuid);
        if (player == null) {
            return;
        }
        this.playerUUID = uuid;
        this.blockEntity.setChanged();
    }

    public static void setPlacedBy(Level level, BlockPos pos, LivingEntity placer) {
        BlockEntity be;
        if (placer == null || !(placer instanceof Player)) {
            return;
        }
        Player player = (Player)placer;
        try {
            be = level.getBlockEntity(pos);
        }
        catch (ConcurrentModificationException e) {
            be = null;
        }
        if (be == null || !(be instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity sbe = (SmartBlockEntity)be;
        AbstractRememberPlacerBehaviour.setPlacedBy(sbe, player);
    }

    public static void setPlacedBy(SmartBlockEntity be, Player player) {
        if (player == null) {
            return;
        }
        for (BlockEntityBehaviour behaviour : be.getAllBehaviours()) {
            AbstractRememberPlacerBehaviour arpb;
            if (!(behaviour instanceof AbstractRememberPlacerBehaviour) || !(arpb = (AbstractRememberPlacerBehaviour)behaviour).shouldRememberPlacer(player)) continue;
            arpb.setPlayer(player.getUUID());
        }
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        if (nbt.contains("Owner")) {
            this.playerUUID = nbt.getUUID("Owner");
        }
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(nbt, registries, clientPacket);
        Player player = this.getPlayer();
        if (!nbt.contains("Owner") && player != null && this.shouldRememberPlacer(player)) {
            nbt.putUUID("Owner", this.playerUUID);
        }
    }
}

