/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.tube;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.PetrolparkKeys;
import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.CreateClient;
import com.petrolpark.compat.create.core.tube.BuildTubePacket;
import com.petrolpark.compat.create.core.tube.ITubeBlock;
import com.petrolpark.compat.create.core.tube.TubeSpline;
import com.petrolpark.util.BlockFace;
import com.petrolpark.util.Lang;
import com.petrolpark.util.Pair;
import com.petrolpark.util.RayHelper;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.mixin.accessor.MouseHandlerAccessor;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;

@OnlyIn(value=Dist.CLIENT)
@RequiresCreate
public class ClientTubePlacementHandler {
    public static final int TIMEOUT = 12000;
    protected static ItemStack currentStack = ItemStack.EMPTY;
    protected static ITubeBlock tubeBlock = null;
    protected static BlockFace start = null;
    protected static BlockFace end = null;
    protected static TubeSpline spline = null;
    protected static int ttl = 0;
    protected static int targetedControlPoint = -1;
    protected static double distanceToSelectedControlPoint = 0.0;
    protected static boolean draggingSelectedControlPoint = false;
    protected static List<AABB> controlPointBoxes = new ArrayList<AABB>();
    protected static boolean canAfford = true;
    public static final LayeredDraw.Layer OVERLAY = ClientTubePlacementHandler::renderOverlay;

    @SubscribeEvent
    public static void tick(ClientTickEvent.Pre event) {
        Vec3 point;
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        LocalPlayer player = mc.player;
        if (level == null || player == null || !ItemStack.isSameItem((ItemStack)player.getItemInHand(InteractionHand.MAIN_HAND), (ItemStack)currentStack) && !AllItems.WRENCH.isIn(player.getMainHandItem()) || currentStack.isEmpty() || start != null && level.getBlockState(start.getPos()).getBlock() != tubeBlock) {
            ClientTubePlacementHandler.cancel();
            return;
        }
        if (ttl > 0) {
            --ttl;
        } else {
            ClientTubePlacementHandler.cancel();
        }
        if (!ClientTubePlacementHandler.active()) {
            return;
        }
        if (level.getBlockState(end.getPos()).getBlock() != tubeBlock) {
            ClientTubePlacementHandler.cancel();
            return;
        }
        boolean buildable = ClientTubePlacementHandler.spline.getResult().success;
        int color = buildable ? -11671936 : -1684096;
        for (int i = 0; i < spline.getPoints().size() - 1; ++i) {
            point = spline.getPoints().get(i);
            Vec3 tangent = spline.getTangents().get(i);
            CreateClient.OUTLINER.showLine(Pair.of(point, tangent), point, spline.getPoints().get(i + 1)).colored(color);
        }
        spline.checkBlocked((Level)mc.level, pos -> CreateClient.OUTLINER.chaseAABB(Pair.of("blocking_tube", pos), new AABB(pos)).colored(-1684096));
        canAfford = spline.checkCanAfford((Player)mc.player, currentStack.getItem(), tubeBlock);
        if (controlPointBoxes.isEmpty()) {
            controlPointBoxes = spline.getControlPoints().stream().map(v -> new AABB(v.subtract(0.09375, 0.09375, 0.09375), v.add(0.09375, 0.09375, 0.09375))).toList();
        }
        if (!draggingSelectedControlPoint && !controlPointBoxes.isEmpty()) {
            point = RayHelper.getHitResult(controlPointBoxes, (Entity)mc.player, AnimationTickHolder.getPartialTicks(), false);
            if (point instanceof RayHelper.CustomHitResult) {
                RayHelper.CustomHitResult hr = (RayHelper.CustomHitResult)point;
                targetedControlPoint = hr.index;
            } else {
                targetedControlPoint = -1;
            }
        } else if (targetedControlPoint != -1) {
            ClientTubePlacementHandler.relocateControlPoint();
        }
        for (int i = 0; i < controlPointBoxes.size(); ++i) {
            AABB controlPointBox = controlPointBoxes.get(i);
            CreateClient.OUTLINER.showBox(Pair.of("control_point", i), controlPointBox.inflate(i == targetedControlPoint ? 0.0625 : 0.0), 2).colored(color);
        }
        player.displayClientMessage(ClientTubePlacementHandler.spline.result.translate(currentStack), true);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderOverlay(GuiGraphics graphics, DeltaTracker deltaTracker) {
        void var8_12;
        if (spline == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ItemStack itemIcon = currentStack.copyWithCount(1);
        String requiredItemCount = "" + tubeBlock.getItemsForTubeLength(spline.getLength());
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(Component.translatable((String)"petrolpark.tube.title", (Object[])new Object[]{requiredItemCount, currentStack.getHoverName()}));
        Controls[] controlsArray = Controls.values();
        int n = controlsArray.length;
        boolean bl = false;
        while (var8_12 < n) {
            Controls control = controlsArray[var8_12];
            if (control.canUse()) {
                tooltip.add(control.translate());
            }
            ++var8_12;
        }
        int tooltipTextWidth = 0;
        for (Component component : tooltip) {
            tooltipTextWidth = Math.max(tooltipTextWidth, mc.font.width((FormattedText)component));
        }
        int tooltipHeight = tooltip.size() * 10;
        CClient cClient = AllConfigs.client();
        int posX = graphics.guiWidth() / 2 + (Integer)cClient.overlayOffsetX.get();
        int posY = graphics.guiHeight() / 2 + (Integer)cClient.overlayOffsetY.get();
        posX = Math.min(posX, graphics.guiWidth() - tooltipTextWidth - 20);
        posY = Math.min(posY, graphics.guiHeight() - tooltipHeight - 20);
        boolean useCustom = (Boolean)cClient.overlayCustomColor.get();
        Color colorBackground = useCustom ? new Color(((Integer)cClient.overlayBackgroundColor.get()).intValue()) : new Color(1007685648);
        Color colorBorderTop = useCustom ? new Color(((Integer)cClient.overlayBorderColorTop.get()).intValue()) : new Color(-3565748);
        Color colorBorderBot = useCustom ? new Color(((Integer)cClient.overlayBorderColorBot.get()).intValue()) : new Color(-926343);
        PoseStack ms = graphics.pose();
        ms.pushPose();
        GuiGameElement.of((ItemStack)itemIcon).at((float)(posX + 10), (float)(posY - 16), 450.0f).render(graphics);
        if (!Mods.MODERNUI.isLoaded()) {
            RemovedGuiUtils.drawHoveringText((GuiGraphics)graphics, tooltip, (int)posX, (int)posY, (int)graphics.guiWidth(), (int)graphics.guiHeight(), (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.font);
            ms.translate(0.0f, 0.0f, 100.0f);
        } else {
            MouseHandler mouseHandler = mc.mouseHandler;
            Window window = mc.getWindow();
            double guiScale = window.getGuiScale();
            double cursorX = mouseHandler.xpos();
            double cursorY = mouseHandler.ypos();
            ((MouseHandlerAccessor)mouseHandler).create$setXPos((double)Math.round(cursorX / guiScale) * guiScale);
            ((MouseHandlerAccessor)mouseHandler).create$setYPos((double)Math.round(cursorY / guiScale) * guiScale);
            RemovedGuiUtils.drawHoveringText((GuiGraphics)graphics, tooltip, (int)posX, (int)posY, (int)graphics.guiWidth(), (int)graphics.guiHeight(), (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.font);
            ((MouseHandlerAccessor)mouseHandler).create$setXPos(cursorX);
            ((MouseHandlerAccessor)mouseHandler).create$setYPos(cursorY);
        }
        ms.popPose();
    }

    @SubscribeEvent
    public static void onUseMouse(InputEvent.MouseButton.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && spline != null && targetedControlPoint > 0 && targetedControlPoint < spline.getControlPoints().size() - 1 && event.getButton() == 1 && draggingSelectedControlPoint == (event.getAction() == 0)) {
            draggingSelectedControlPoint = !draggingSelectedControlPoint;
            distanceToSelectedControlPoint = player.getEyePosition().distanceTo(spline.getControlPoints().get(targetedControlPoint));
            ClientTubePlacementHandler.resetTTL();
        }
    }

    @SubscribeEvent
    public static void onScrollMouse(InputEvent.MouseScrollingEvent event) {
        if (draggingSelectedControlPoint) {
            distanceToSelectedControlPoint = Mth.clamp((double)(distanceToSelectedControlPoint + event.getScrollDeltaY() / 8.0), (double)Math.min(distanceToSelectedControlPoint, 0.5), (double)Math.max(distanceToSelectedControlPoint, 6.0));
            ClientTubePlacementHandler.relocateControlPoint();
            event.setCanceled(true);
            ClientTubePlacementHandler.resetTTL();
        }
    }

    @SubscribeEvent
    public static void onUseKey(InputEvent.Key event) {
        if (spline == null) {
            return;
        }
        if (event.getAction() == 0) {
            Minecraft mc = Minecraft.getInstance();
            for (Controls control : Controls.values()) {
                if (!control.canUse() || control.key == null || event.getKey() != control.key.keybind.getKey().getValue()) continue;
                control.key.keybind.consumeClick();
                control.use();
                if (spline != null) {
                    controlPointBoxes = new ArrayList<AABB>();
                    ClientTubePlacementHandler.revalidateSpline(mc);
                }
                ClientTubePlacementHandler.resetTTL();
                return;
            }
        }
    }

    protected static void relocateControlPoint() {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        LocalPlayer player = mc.player;
        if (level != null && player != null && spline.moveControlPoint(targetedControlPoint, player.getEyePosition().add(player.getViewVector(AnimationTickHolder.getPartialTicks()).scale(distanceToSelectedControlPoint)))) {
            controlPointBoxes = new ArrayList<AABB>();
            level.playSound((Player)player, player.getOnPos(), SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.25f, 0.1f);
            ClientTubePlacementHandler.revalidateSpline(mc);
        }
    }

    public static void tryConnect(BlockFace location, ItemStack stack, ITubeBlock tubeBlock, boolean manualPlacement) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (start == null) {
            currentStack = stack;
            ClientTubePlacementHandler.tubeBlock = tubeBlock;
            start = location;
            spline = null;
            if (manualPlacement && player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"petrolpark.tube.connect_another", (Object[])new Object[]{stack.getHoverName()}), true);
            }
            ClientTubePlacementHandler.resetTTL();
        } else if (spline == null) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentStack)) {
                ClientTubePlacementHandler.cancel();
                return;
            }
            end = location;
            spline = new TubeSpline(start, end, tubeBlock.getTubeMaxAngle(), tubeBlock.getTubeSegmentLength(), tubeBlock.getTubeSegmentRadius());
            if (manualPlacement) {
                spline.addControlPoint(start.getCenter().add(end.getCenter()).scale(0.5));
            }
            ClientTubePlacementHandler.revalidateSpline(mc);
            ClientTubePlacementHandler.resetTTL();
        } else {
            ClientTubePlacementHandler.cancel();
            ClientTubePlacementHandler.tryConnect(location, stack, tubeBlock, manualPlacement);
        }
    }

    public static void revalidateSpline(Minecraft mc) {
        spline.validate((Level)mc.level, (Player)mc.player, currentStack.getItem(), tubeBlock);
    }

    public static void addControlPointWithoutRevalidating(Vec3 controlPoint) {
        if (spline != null) {
            spline.addControlPoint(controlPoint);
        }
    }

    public static void resetTTL() {
        ttl = 12000;
    }

    public static boolean active() {
        return spline != null;
    }

    public static void cancel() {
        currentStack = ItemStack.EMPTY;
        tubeBlock = null;
        start = null;
        end = null;
        spline = null;
        ttl = 0;
        targetedControlPoint = -1;
        distanceToSelectedControlPoint = 0.0;
        draggingSelectedControlPoint = false;
        controlPointBoxes = new ArrayList<AABB>();
        canAfford = true;
    }

    protected static enum Controls {
        BUILD(PetrolparkKeys.TUBE_BUILD){

            @Override
            public boolean canUse() {
                return ClientTubePlacementHandler.spline.getResult().success;
            }

            @Override
            public void use() {
                CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new BuildTubePacket(tubeBlock, spline));
                ClientTubePlacementHandler.cancel();
            }
        }
        ,
        GRAB_CONTROL_POINT(null){

            @Override
            public boolean canUse() {
                return targetedControlPoint > 0 && targetedControlPoint < spline.getControlPoints().size() - 1;
            }

            @Override
            public void use() {
            }
        }
        ,
        MOVE_CONTROL_POINT(null){

            @Override
            public boolean canUse() {
                return draggingSelectedControlPoint;
            }

            @Override
            public void use() {
            }
        }
        ,
        DELETE_CONTROL_POINT(PetrolparkKeys.TUBE_DELETE_CONTROL_POINT){

            @Override
            public boolean canUse() {
                return targetedControlPoint > 0 && targetedControlPoint < spline.getControlPoints().size() - 1 && !draggingSelectedControlPoint;
            }

            @Override
            public void use() {
                spline.removeControlPoint(targetedControlPoint);
            }
        }
        ,
        ADD_CONTROL_POINT_AFTER(PetrolparkKeys.TUBE_ADD_CONTROL_POINT_AFTER){

            @Override
            public boolean canUse() {
                return spline.getControlPoints().size() < 16 && targetedControlPoint >= 0 && targetedControlPoint < spline.getControlPoints().size() - 1 && !draggingSelectedControlPoint;
            }

            @Override
            public void use() {
                spline.addInterpolatedControlPoint(targetedControlPoint + 1);
            }
        }
        ,
        ADD_CONTROL_POINT_BEFORE(PetrolparkKeys.TUBE_ADD_CONTROL_POINT_BEFORE){

            @Override
            public boolean canUse() {
                return spline.getControlPoints().size() < 16 && targetedControlPoint > 0 && targetedControlPoint < spline.getControlPoints().size();
            }

            @Override
            public void use() {
                spline.addInterpolatedControlPoint(targetedControlPoint);
            }
        }
        ,
        CANCEL(PetrolparkKeys.TUBE_CANCEL){

            @Override
            public boolean canUse() {
                return true;
            }

            @Override
            public void use() {
                ClientTubePlacementHandler.cancel();
            }
        };

        public final PetrolparkKeys key;

        private Controls(PetrolparkKeys key) {
            this.key = key;
        }

        public abstract boolean canUse();

        public abstract void use();

        public Component translate() {
            return Component.translatable((String)("petrolpark.tube.control." + Lang.asId(this.name())), (Object[])new Object[]{this.key == null ? "" : this.key.keybind.getKey().getDisplayName()}).withStyle(ChatFormatting.GRAY);
        }
    }
}

