/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.compat.create.CreateBlocks;
import com.petrolpark.compat.jei.JEIBlockRenderer;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.BasinCategory;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import net.minecraft.client.gui.GuiGraphics;

public class LiddedBasinCategory
extends BasinCategory {
    private final JEIBlockRenderer blockRenderer = new JEIBlockRenderer();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();

    public LiddedBasinCategory(CreateRecipeCategory.Info<BasinRecipe> info, IJeiHelpers helpers) {
        super(info, true);
    }

    public void draw(@Nonnull BasinRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, graphics, mouseX, mouseY);
        PoseStack ms = graphics.pose();
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (requiredHeat != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, this.getBackground().getWidth() / 2 + 3, 55);
        }
        ms.pushPose();
        ms.translate((float)(this.getBackground().getWidth() / 2 + 3), 71.0f, 0.0f);
        this.blockRenderer.renderBlock(AllBlocks.BASIN.getDefaultState(), graphics, 23.0);
        ms.translate(0.0f, -21.0f, 0.0f);
        this.blockRenderer.renderBlock(CreateBlocks.BASIN_LID.getDefaultState(), graphics, 23.0);
        ms.popPose();
    }
}

