/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.petrolpark.core.codec.ContextualDecoder;
import com.petrolpark.core.codec.ContextualEncoder;
import com.petrolpark.core.codec.ContextualMapCodec;
import com.petrolpark.core.codec.ContextualOptionalFieldCodec;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ContextualCodec<CONTEXT, A>
extends ContextualEncoder<CONTEXT, A>,
ContextualDecoder<CONTEXT, A> {
    public static <CONTEXT, A> ContextualCodec<CONTEXT, A> of(final Codec<A> codec) {
        return new ContextualCodec<CONTEXT, A>(){

            @Override
            public <T> DataResult<T> encode(A input, CONTEXT context, DynamicOps<T> ops, T prefix) {
                return codec.encode(input, ops, prefix);
            }

            @Override
            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, CONTEXT context, T input) {
                return codec.decode(ops, input);
            }

            public String toString() {
                return "Wrapped[" + String.valueOf(codec) + "]";
            }
        };
    }

    public static <CONTEXT, A> ContextualCodec<CONTEXT, A> of(final ContextualEncoder<CONTEXT, A> encoder, final ContextualDecoder<CONTEXT, A> decoder, final String name) {
        return new ContextualCodec<CONTEXT, A>(){

            @Override
            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, CONTEXT context, T input) {
                return decoder.decode(ops, context, input);
            }

            @Override
            public <T> DataResult<T> encode(A input, CONTEXT context, DynamicOps<T> ops, T prefix) {
                return encoder.encode(input, context, ops, prefix);
            }

            public String toString() {
                return name;
            }
        };
    }

    public static <CONTEXT, A> ContextualCodec<CONTEXT, A> unit(A defaultValue) {
        return ContextualCodec.unit(() -> defaultValue);
    }

    public static <CONTEXT, A> ContextualCodec<CONTEXT, A> unit(Supplier<A> defaultValue) {
        return ContextualMapCodec.unit(defaultValue).codec();
    }

    public static <CONTEXT, F> ContextualMapCodec<CONTEXT, Optional<F>> optionalField(String name, ContextualCodec<CONTEXT, F> elementCodec, boolean lenient) {
        return new ContextualOptionalFieldCodec<CONTEXT, F>(name, elementCodec, lenient);
    }

    default public <S> ContextualCodec<CONTEXT, S> xmap(Function<? super A, ? extends S> to, Function<? super S, ? extends A> from) {
        return ContextualCodec.of(this.comap(from), this.map(to), this.toString() + "[xmapped]");
    }

    public static <CONTEXT, A> ContextualCodec<CONTEXT, A> withContext(final ContextualCodec<CONTEXT, A> codec, final CONTEXT newContext) {
        return new ContextualCodec<CONTEXT, A>(){

            @Override
            public <T> DataResult<T> encode(A input, CONTEXT context, DynamicOps<T> ops, T prefix) {
                return codec.encode(input, newContext, ops, prefix);
            }

            @Override
            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, CONTEXT context, T input) {
                return codec.decode(ops, newContext, input);
            }
        };
    }

    default public ContextualCodec<CONTEXT, A> withContext(CONTEXT newContext) {
        return ContextualCodec.withContext(this, newContext);
    }

    @Override
    default public ContextualMapCodec<CONTEXT, A> fieldOf(String name) {
        return ContextualMapCodec.of(ContextualEncoder.super.fieldOf(name), ContextualDecoder.super.fieldOf(name), () -> "Field[" + name + ": " + this.toString() + "]");
    }

    default public ContextualMapCodec<CONTEXT, Optional<A>> optionalFieldOf(String name) {
        return ContextualCodec.optionalField(name, this, false);
    }
}

