/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.contamination;

import com.petrolpark.core.contamination.ComponentHolderContamination;
import com.petrolpark.core.contamination.Contaminable;
import com.petrolpark.core.contamination.Contaminables;
import com.petrolpark.core.contamination.IContamination;
import com.petrolpark.core.contamination.IncontaminableContamination;
import java.util.stream.Stream;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidContamination
extends ComponentHolderContamination<Fluid, FluidStack> {
    public static IContamination<?, ?> get(FluidStack stack) {
        if (!Contaminables.FLUID.isContaminableStack(stack)) {
            return new FluidContamination(stack);
        }
        return IncontaminableContamination.INSTANCE;
    }

    public static void perpetuate(Stream<FluidStack> inputs, FluidStack output) {
        FluidContamination.perpetuate(inputs, Stream.of(output));
    }

    public static void perpetuate(Stream<FluidStack> inputs, Stream<FluidStack> outputs) {
        IContamination.perpetuate(inputs, outputs, FluidContamination::get);
    }

    protected FluidContamination(FluidStack stack) {
        super(stack);
    }

    @Override
    public Contaminable<Fluid, FluidStack> getContaminable() {
        return Contaminables.FLUID;
    }

    @Override
    public Fluid getType() {
        return ((FluidStack)this.stack).getFluid();
    }

    @Override
    public double getAmount() {
        return ((FluidStack)this.stack).getAmount();
    }
}

