/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkLootConditionTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record ParameterSuppliedLootCondition(List<LootContextParam<Object>> params) implements LootItemCondition
{
    protected static final Map<ResourceLocation, LootContextParam<Object>> KNOWN_PARAMS = new HashMap<ResourceLocation, LootContextParam<Object>>();
    public static final MapCodec<ParameterSuppliedLootCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.xmap(KNOWN_PARAMS::get, LootContextParam::getName).listOf().fieldOf("parameters").forGetter(ParameterSuppliedLootCondition::params)).apply((Applicative)instance, ParameterSuppliedLootCondition::new));

    public static final void makeKnown(Collection<LootContextParam<? extends Object>> params) {
        for (LootContextParam<? extends Object> param : params) {
            ParameterSuppliedLootCondition.makeKnown(param);
        }
    }

    public static final void makeKnown(LootContextParam<Object> param) {
        KNOWN_PARAMS.put(param.getName(), param);
    }

    public static final LootContextParam<?> byName(String name) {
        return KNOWN_PARAMS.get(ResourceLocation.parse((String)name));
    }

    public boolean test(LootContext context) {
        for (LootContextParam<Object> param : this.params) {
            if (context.hasParam(param)) continue;
            return false;
        }
        return true;
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)PetrolparkLootConditionTypes.PARAMETERS_SUPPLIED.get();
    }

    static {
        ParameterSuppliedLootCondition.makeKnown(List.of(LootContextParams.BLOCK_ENTITY, LootContextParams.BLOCK_STATE, LootContextParams.DAMAGE_SOURCE, LootContextParams.DIRECT_ATTACKING_ENTITY, LootContextParams.EXPLOSION_RADIUS, LootContextParams.ATTACKING_ENTITY, LootContextParams.LAST_DAMAGE_PLAYER, LootContextParams.ORIGIN, LootContextParams.THIS_ENTITY, LootContextParams.TOOL));
    }
}

