/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider;

import com.google.common.collect.Sets;
import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkLootContextParams;
import com.petrolpark.PetrolparkNumberProviderTypes;
import com.petrolpark.core.data.loot.numberprovider.IEstimableNumberProvider;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import com.petrolpark.core.data.loot.numberprovider.team.TeamNumberProvider;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.util.CodecHelper;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;

public record ContextTeamNumberProvider(TeamNumberProvider value) implements IEstimableNumberProvider
{
    public static final MapCodec<ContextTeamNumberProvider> CODEC = CodecHelper.singleFieldMap(TeamNumberProvider.CODEC, "value", ContextTeamNumberProvider::value, ContextTeamNumberProvider::new);

    public float getFloat(@Nonnull LootContext context) {
        ITeam team = (ITeam)context.getParam(PetrolparkLootContextParams.TEAM);
        if (team != null) {
            return this.value.getFloat(team, context);
        }
        return 0.0f;
    }

    @Override
    public NumberEstimate getEstimate() {
        return this.value().getEstimate();
    }

    @Override
    public float getMaxFloat(LootContext context) {
        ITeam team = (ITeam)context.getParam(PetrolparkLootContextParams.TEAM);
        if (team != null) {
            return this.value.getMaxFloat(team, context);
        }
        return 0.0f;
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)PetrolparkNumberProviderTypes.CONTEXT_TEAM.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Sets.union(Set.of(PetrolparkLootContextParams.TEAM), (Set)this.value.getReferencedContextParams());
    }
}

