/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider;

import com.mojang.serialization.MapCodec;
import com.petrolpark.core.data.loot.numberprovider.IEstimableNumberProvider;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import com.petrolpark.util.CodecHelper;
import java.util.List;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public abstract class FunctionNumberProvider
implements IEstimableNumberProvider {
    protected final List<NumberProvider> children;

    public static final <PROVIDER extends FunctionNumberProvider> MapCodec<PROVIDER> codec(Function<List<NumberProvider>, PROVIDER> constructor) {
        return CodecHelper.singleFieldMap(NumberProviders.CODEC.listOf(), "values", FunctionNumberProvider::getChildren, constructor);
    }

    public FunctionNumberProvider(List<NumberProvider> children) {
        this.children = children;
    }

    public List<NumberProvider> getChildren() {
        return this.children;
    }

    public final float getFloat(@Nonnull LootContext lootContext) {
        return this.apply(lootContext, this.children.stream().mapToDouble(child -> child.getFloat(lootContext)));
    }

    @Override
    public final NumberEstimate getEstimate() {
        return this.applyEstimate(this.children.stream().map(NumberEstimate::get).dropWhile(NumberEstimate::unknown));
    }

    @Override
    public final float getMaxFloat(LootContext context) {
        return this.apply(context, this.children.stream().mapToDouble(p -> NumberEstimate.getMax(context, p)));
    }

    public abstract float apply(LootContext var1, DoubleStream var2);

    public abstract NumberEstimate applyEstimate(Stream<NumberEstimate> var1);
}

