/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkNumberProviderTypes;
import com.petrolpark.core.data.loot.numberprovider.IEstimableNumberProvider;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record SigmoidNumberProvider(NumberProvider shallowness, NumberProvider midpoint, NumberProvider value) implements IEstimableNumberProvider
{
    public static final MapCodec<SigmoidNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviders.CODEC.fieldOf("shallowness").forGetter(SigmoidNumberProvider::shallowness), (App)NumberProviders.CODEC.fieldOf("midpoint").forGetter(SigmoidNumberProvider::midpoint), (App)NumberProviders.CODEC.fieldOf("value").forGetter(SigmoidNumberProvider::value)).apply((Applicative)instance, SigmoidNumberProvider::new));

    public float getFloat(@Nonnull LootContext lootContext) {
        float shallowness = this.shallowness.getFloat(lootContext);
        if (shallowness == 0.0f) {
            return 1.0f;
        }
        return 1.0f / (1.0f + (float)Math.exp((this.midpoint.getFloat(lootContext) - this.value.getFloat(lootContext)) / shallowness));
    }

    @Override
    public float getMaxFloat(LootContext context) {
        return Float.MAX_VALUE;
    }

    @Override
    public NumberEstimate getEstimate() {
        return NumberEstimate.ONE.add(NumberEstimate.get(this.midpoint()).subtract(NumberEstimate.get(this.value())).divide(NumberEstimate.get(this.shallowness())).exp()).reciprocal();
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)PetrolparkNumberProviderTypes.SIGMOID.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Sets.union((Set)this.shallowness.getReferencedContextParams(), (Set)this.midpoint.getReferencedContextParams());
    }
}

