/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkNumberProviderTypes;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import com.petrolpark.core.data.loot.numberprovider.entity.EntityNumberProvider;
import com.petrolpark.core.data.loot.numberprovider.entity.LootEntityNumberProviderType;
import com.petrolpark.core.data.loot.numberprovider.itemstack.ItemStackNumberProvider;
import java.util.Set;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;

public record EquipmentNumberProvider(EquipmentSlot slot, ItemStackNumberProvider value) implements EntityNumberProvider
{
    public static final MapCodec<EquipmentNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StringRepresentable.fromEnum(EquipmentSlot::values).optionalFieldOf("slot", (Object)EquipmentSlot.MAINHAND).forGetter(EquipmentNumberProvider::slot), (App)ItemStackNumberProvider.CODEC.fieldOf("value").forGetter(EquipmentNumberProvider::value)).apply((Applicative)instance, EquipmentNumberProvider::new));

    @Override
    public float getFloat(Entity entity, LootContext lootContext) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return this.value.getFloat(livingEntity.getItemBySlot(this.slot), lootContext);
        }
        return 0.0f;
    }

    @Override
    public float getMaxFloat(Entity entity, LootContext lootContext) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return this.value.getMaxFloat(livingEntity.getItemBySlot(this.slot), lootContext);
        }
        return 0.0f;
    }

    @Override
    public NumberEstimate getEstimate() {
        return this.value().getEstimate();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.value.getReferencedContextParams();
    }

    @Override
    public LootEntityNumberProviderType getType() {
        return (LootEntityNumberProviderType)PetrolparkNumberProviderTypes.EQUIPMENT.get();
    }
}

