/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.bogglepattern;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.core.recipe.bogglepattern.BogglePattern;
import com.petrolpark.core.recipe.bogglepattern.BogglePatternHelper;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class BogglePatternCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"petrolpark").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bogglepattern").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"list").executes(ctx -> BogglePatternCommand.list((CommandSourceStack)ctx.getSource())))).then(Commands.literal((String)"show").then(Commands.argument((String)"bogglepattern", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, PetrolparkRegistries.Keys.BOGGLE_PATTERN)).executes(ctx -> BogglePatternCommand.show((CommandSourceStack)ctx.getSource(), (Holder<BogglePattern>)ResourceArgument.getResource((CommandContext)ctx, (String)"bogglepattern", PetrolparkRegistries.Keys.BOGGLE_PATTERN)))))).then(Commands.literal((String)"regenerate").then(Commands.argument((String)"bogglepattern", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, PetrolparkRegistries.Keys.BOGGLE_PATTERN)).executes(ctx -> BogglePatternCommand.regenerate((CommandSourceStack)ctx.getSource(), (Holder<BogglePattern>)ResourceArgument.getResource((CommandContext)ctx, (String)"bogglepattern", PetrolparkRegistries.Keys.BOGGLE_PATTERN)))))));
    }

    private static int list(CommandSourceStack source) {
        Registry registry = (Registry)source.registryAccess().registry(PetrolparkRegistries.Keys.BOGGLE_PATTERN).get();
        source.sendSuccess(() -> Component.translatable((String)"commands.petrolpark.bogglepattern.list", (Object[])new Object[]{registry.size(), ComponentUtils.formatList(registry.keySet().stream().map(ResourceLocation::toString).toList())}), false);
        return registry.size();
    }

    private static int show(CommandSourceStack source, Holder<BogglePattern> bogglePattern) {
        int pattern = ((BogglePattern)bogglePattern.value()).getOrGeneratePattern((Level)source.getLevel());
        source.sendSuccess(() -> Component.translatable((String)"commands.petrolpark.bogglepattern.show", (Object[])new Object[]{bogglePattern.getKey().location().toString()}), false);
        for (String line : BogglePatternHelper.format(pattern)) {
            source.sendSuccess(() -> Component.literal((String)line), false);
        }
        return pattern;
    }

    private static int regenerate(CommandSourceStack source, Holder<BogglePattern> bogglePattern) {
        ((BogglePattern)bogglePattern.value()).forgetPattern();
        return BogglePatternCommand.show(source, bogglePattern);
    }
}

