/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.book;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkDataComponents;
import com.petrolpark.compat.jei.PetrolparkJEI;
import com.petrolpark.core.recipe.book.RecipeReferenceDataComponent;
import com.simibubi.create.compat.Mods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mezz.jei.gui.overlay.bookmarks.PreviewTooltipComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class RecipeBookItem
extends Item {
    public static Stream<RecipeHolder<?>> streamProvidedRecipes(Level level, ItemStack stack) {
        List recipesComponent = (List)stack.get(DataComponents.RECIPES);
        Stream<Object> recipes = recipesComponent != null ? recipesComponent.stream().flatMap(rl -> level.getRecipeManager().byKey(rl).stream()) : Stream.empty();
        RecipeReferenceDataComponent recipeReferenceComponent = (RecipeReferenceDataComponent)stack.get(PetrolparkDataComponents.RECIPE_REFERENCE);
        if (recipeReferenceComponent != null) {
            recipes = Stream.concat(recipes, recipeReferenceComponent.getRecipeHolder(level.getRecipeManager()).stream());
        }
        return recipes;
    }

    public RecipeBookItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!level.isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.awardRecipes(RecipeBookItem.streamProvidedRecipes(level, stack).toList());
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        RecipeReferenceDataComponent recipeReference = (RecipeReferenceDataComponent)stack.get(PetrolparkDataComponents.RECIPE_REFERENCE);
        Level level = context.level();
        if (level != null && recipeReference != null) {
            if (recipeReference.jeiRecipeTypeId().isPresent() && Mods.JEI.isLoaded()) {
                return;
            }
            tooltipComponents.add((Component)recipeReference.getRecipeName(level.getRecipeManager()).copy().withStyle(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(@Nonnull ItemStack stack) {
        return Mods.JEI.runIfInstalled(() -> () -> this.getJeiTooltipImage(stack)).orElse(Optional.empty());
    }

    public Optional<TooltipComponent> getJeiTooltipImage(@Nonnull ItemStack stack) {
        return (Optional)Petrolpark.runForDist(() -> () -> {
            Minecraft mc = Minecraft.getInstance();
            ClientPacketListener connection = mc.getConnection();
            RecipeReferenceDataComponent recipeReference = (RecipeReferenceDataComponent)stack.get(PetrolparkDataComponents.RECIPE_REFERENCE);
            if (connection == null || recipeReference == null || PetrolparkJEI.JEI_RUNTIME == null) {
                return Optional.empty();
            }
            return PetrolparkJEI.RECIPE_BOOK_ITEM_JEI_CATEGORY_CACHE.get(recipeReference, connection.getRecipeManager()).map(layout -> new PreviewTooltipComponent(layout));
        }, () -> Optional::empty);
    }
}

