/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkAdvancedIngredientTypes;
import com.petrolpark.core.recipe.ingredient.advanced.INamedAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.advanced.ItemAdvancedIngredient;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;

public record HolderSetItemAdvancedIngredient(HolderSet<Item> set) implements ItemAdvancedIngredient
{
    public static final MapCodec<HolderSetItemAdvancedIngredient> CODEC = CodecHelper.singleFieldMap(RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM), "set", HolderSetItemAdvancedIngredient::set, HolderSetItemAdvancedIngredient::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, HolderSetItemAdvancedIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.ITEM), HolderSetItemAdvancedIngredient::set, HolderSetItemAdvancedIngredient::new);

    @Override
    public boolean test(ItemStack stack) {
        return this.set.contains(stack.getItemHolder());
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder description) {
        this.set.unwrap().map(tag -> description.add((Component)Component.translatable((String)"advanced_ingredient.petrolpark.tag", (Object[])new Object[]{tag})), items -> {
            description.add(this.translate("", new Object[0])).indent();
            items.stream().map(Holder::value).map(Item::getDescription).forEach(description::add);
            return description.unindent();
        });
    }

    @Override
    public void addToCounterDescription(Lang.IndentedTooltipBuilder description) {
        this.set.unwrap().map(tag -> description.add((Component)Component.translatable((String)"advanced_ingredient.petrolpark.tag.inverse", (Object[])new Object[]{tag})), items -> {
            description.add(this.translateInverse(new Object[0])).indent();
            items.stream().map(Holder::value).map(Item::getDescription).forEach(description::add);
            return description.unindent();
        });
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forceTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        return ItemAdvancedIngredient.super.forceTradeListing(tradeListing, trader, random);
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forbidTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        return ItemAdvancedIngredient.super.forbidTradeListing(tradeListing, trader, random);
    }

    @Override
    public INamedAdvancedIngredientType<ItemStack> getType() {
        return (INamedAdvancedIngredientType)PetrolparkAdvancedIngredientTypes.ITEM_HOLDER_SET.get();
    }
}

