/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.scratch;

import com.petrolpark.core.scratch.ScratchSignature;
import com.petrolpark.core.scratch.argument.IScratchArgument;
import com.petrolpark.core.scratch.environment.IScratchEnvironment;
import com.petrolpark.core.scratch.procedure.IScratchContext;
import java.util.Collection;
import java.util.stream.Stream;

public sealed interface ScratchArguments<ENVIRONMENT extends IScratchEnvironment, SIGNATURE extends ScratchSignature>
extends ScratchSignature {
    public static <ENVIRONMENT extends IScratchEnvironment> ScratchArguments<ENVIRONMENT, ?> of(Collection<IScratchArgument<? super ENVIRONMENT, ?>> arguments) {
        if (arguments.isEmpty()) {
            return new None();
        }
        if (arguments.size() == 1) {
            return new Just(arguments.iterator().next());
        }
        Builder builder = new None.Builder();
        for (IScratchArgument<ENVIRONMENT, ?> iScratchArgument : arguments) {
            builder = builder.after(iScratchArgument);
        }
        return builder.build();
    }

    public Stream<IScratchArgument<? super ENVIRONMENT, ?>> stream();

    public static sealed class None<ENVIRONMENT extends IScratchEnvironment>
    implements ScratchArguments<ENVIRONMENT, ScratchSignature.None>,
    ScratchSignature.None {
        @Override
        public Stream<IScratchArgument<? super ENVIRONMENT, ?>> stream() {
            return Stream.empty();
        }

        public static final class Builder<ENVIRONMENT extends IScratchEnvironment>
        extends None<ENVIRONMENT>
        implements com.petrolpark.core.scratch.ScratchArguments$Builder<ENVIRONMENT> {
            public <TYPE, ARGUMENT extends IScratchArgument<? super ENVIRONMENT, TYPE>> Just.Builder<ENVIRONMENT, TYPE, ARGUMENT> after(ARGUMENT argument) {
                return new Just.Builder(argument);
            }

            public None<ENVIRONMENT> build() {
                return new None();
            }
        }
    }

    public static sealed class Just<ENVIRONMENT extends IScratchEnvironment, TYPE, ARGUMENT extends IScratchArgument<? super ENVIRONMENT, TYPE>>
    extends More<ENVIRONMENT, TYPE, ARGUMENT>
    implements ScratchSignature.Just<TYPE> {
        protected Just(ARGUMENT argument) {
            super(argument);
        }

        public static final class Builder<ENVIRONMENT extends IScratchEnvironment, TYPE, ARGUMENT extends IScratchArgument<? super ENVIRONMENT, TYPE>>
        extends Just<ENVIRONMENT, TYPE, ARGUMENT>
        implements More.Builder<ENVIRONMENT> {
            protected Builder(ARGUMENT argument) {
                super(argument);
            }

            public <PREVIOUS_TYPE, PREVIOUS_ARGUMENT extends IScratchArgument<? super ENVIRONMENT, PREVIOUS_TYPE>> And.Builder<ENVIRONMENT, PREVIOUS_TYPE, PREVIOUS_ARGUMENT, Just<ENVIRONMENT, TYPE, ARGUMENT>> after(PREVIOUS_ARGUMENT previousArgument) {
                return new And.Builder(previousArgument, this.build());
            }

            public Just<ENVIRONMENT, TYPE, ARGUMENT> build() {
                return new Just(this.argument);
            }
        }
    }

    public static sealed interface Builder<ENVIRONMENT extends IScratchEnvironment>
    permits None.Builder, More.Builder {
        public <TYPE, ARGUMENT extends IScratchArgument<? super ENVIRONMENT, TYPE>> More.Builder<ENVIRONMENT> after(ARGUMENT var1);

        public ScratchArguments<ENVIRONMENT, ?> build();
    }

    public static abstract sealed class More<ENVIRONMENT extends IScratchEnvironment, TYPE, ARGUMENT extends IScratchArgument<? super ENVIRONMENT, TYPE>>
    implements ScratchArguments<ENVIRONMENT, ScratchSignature.More<TYPE>>,
    ScratchSignature.More<TYPE>
    permits Just, And {
        protected final ARGUMENT argument;

        protected More(ARGUMENT argument) {
            this.argument = argument;
        }

        public ARGUMENT argument() {
            return this.argument;
        }

        @Override
        public Stream<IScratchArgument<? super ENVIRONMENT, ?>> stream() {
            return Stream.of(this.argument);
        }

        public TYPE get(ENVIRONMENT environment, IScratchContext<?> context) {
            return this.argument.get(environment, context);
        }

        public static sealed interface Builder<ENVIRONMENT extends IScratchEnvironment>
        extends com.petrolpark.core.scratch.ScratchArguments$Builder<ENVIRONMENT>
        permits Just.Builder, And.Builder {
        }
    }

    public static sealed class And<ENVIRONMENT extends IScratchEnvironment, TYPE, ARGUMENT extends IScratchArgument<? super ENVIRONMENT, TYPE>, NEXT extends More<? super ENVIRONMENT, ?, ?>>
    extends More<ENVIRONMENT, TYPE, ARGUMENT>
    implements ScratchSignature.And<TYPE, NEXT> {
        protected final NEXT next;

        protected And(ARGUMENT argument, NEXT next) {
            super(argument);
            this.next = next;
        }

        @Override
        public Stream<IScratchArgument<? super ENVIRONMENT, ?>> stream() {
            return Stream.concat(((More)this.next()).stream(), super.stream());
        }

        public NEXT next() {
            return this.next;
        }

        public static final class Builder<ENVIRONMENT extends IScratchEnvironment, TYPE, ARGUMENT extends IScratchArgument<? super ENVIRONMENT, TYPE>, NEXT extends More<? super ENVIRONMENT, ?, ?>>
        extends And<ENVIRONMENT, TYPE, ARGUMENT, NEXT>
        implements More.Builder<ENVIRONMENT> {
            protected Builder(ARGUMENT argument, NEXT next) {
                super(argument, next);
            }

            public <PREVIOUS_TYPE, PREVIOUS_ARGUMENT extends IScratchArgument<? super ENVIRONMENT, PREVIOUS_TYPE>> Builder<ENVIRONMENT, PREVIOUS_TYPE, PREVIOUS_ARGUMENT, And<ENVIRONMENT, TYPE, ARGUMENT, NEXT>> after(PREVIOUS_ARGUMENT previousArgument) {
                return new Builder<ENVIRONMENT, TYPE, PREVIOUS_ARGUMENT, ScratchArguments>(previousArgument, this.build());
            }

            public And<ENVIRONMENT, TYPE, ARGUMENT, NEXT> build() {
                return new And(this.argument, this.next);
            }
        }
    }
}

