/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.scratch.argument;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.petrolpark.core.codec.ContextualCodec;
import com.petrolpark.core.codec.ContextualMapCodec;
import com.petrolpark.core.codec.ContextualStreamCodec;
import com.petrolpark.core.scratch.IScratchClass;
import com.petrolpark.core.scratch.ScratchArguments;
import com.petrolpark.core.scratch.argument.IScratchArgument;
import com.petrolpark.core.scratch.argument.IScratchParameter;
import com.petrolpark.core.scratch.environment.IScratchEnvironment;
import com.petrolpark.core.scratch.procedure.IScratchContext;
import com.petrolpark.core.scratch.procedure.IScratchContextHolder;
import com.petrolpark.core.scratch.symbol.expression.IScratchExpression;
import io.netty.handler.codec.DecoderException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;

public final class ExpressionArgument<ENVIRONMENT extends IScratchEnvironment, TYPE, ARGUMENTS extends ScratchArguments<ENVIRONMENT, ?>>
extends Record
implements IScratchArgument<ENVIRONMENT, TYPE> {
    private final IScratchExpression<ENVIRONMENT, TYPE, ARGUMENTS, ?> expression;
    private final ARGUMENTS arguments;
    private final ExpressionParameter<ENVIRONMENT, TYPE> parameter;

    public ExpressionArgument(IScratchExpression<ENVIRONMENT, TYPE, ARGUMENTS, ?> expression, ARGUMENTS arguments, ExpressionParameter<ENVIRONMENT, TYPE> parameter) {
        this.expression = expression;
        this.arguments = arguments;
        this.parameter = parameter;
    }

    public static final <ENVIRONMENT extends IScratchEnvironment, TYPE> ExpressionParameter<ENVIRONMENT, TYPE> parameter(String key, IScratchClass<TYPE, ?> scratchClass) {
        return new ExpressionParameter(key, scratchClass);
    }

    @Override
    public TYPE get(ENVIRONMENT environment, IScratchContext<?> contxt) {
        return this.expression().evaluate(environment, contxt, this.arguments());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ExpressionArgument.class, "expression;arguments;parameter", "expression", "arguments", "parameter"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ExpressionArgument.class, "expression;arguments;parameter", "expression", "arguments", "parameter"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ExpressionArgument.class, "expression;arguments;parameter", "expression", "arguments", "parameter"}, this, o);
    }

    public IScratchExpression<ENVIRONMENT, TYPE, ARGUMENTS, ?> expression() {
        return this.expression;
    }

    public ARGUMENTS arguments() {
        return this.arguments;
    }

    public ExpressionParameter<ENVIRONMENT, TYPE> parameter() {
        return this.parameter;
    }

    public static final class ExpressionParameter<ENVIRONMENT extends IScratchEnvironment, TYPE>
    implements IScratchParameter<ENVIRONMENT, TYPE, ExpressionArgument<ENVIRONMENT, TYPE, ?>> {
        private static final String EXPRESSION_KEY = "expression";
        private static final String ARGUMENTS_KEY = "arguments";
        private final String key;
        private final IScratchClass<TYPE, ?> scratchClass;
        private final ContextualMapCodec<IScratchContextHolder<?>, ExpressionArgument<ENVIRONMENT, TYPE, ?>> mapCodec = new ContextualMapCodec<IScratchContextHolder<?>, ExpressionArgument<ENVIRONMENT, TYPE, ?>>(){

            @Override
            public <T> DataResult<ExpressionArgument<ENVIRONMENT, TYPE, ?>> decode(DynamicOps<T> ops, IScratchContextHolder<?> context, MapLike<T> input) {
                return IScratchExpression.CODEC.parse(ops, input.get(ExpressionParameter.EXPRESSION_KEY)).flatMap(expression -> {
                    try {
                        if (expression.getReturnClass() != scratchClass) {
                            return DataResult.error(() -> String.format("Expression {} has wrong return type", expression.getExpressionType()));
                        }
                        return DataResult.success((Object)expression);
                    }
                    catch (ClassCastException e) {
                        return DataResult.error(() -> String.format("Expression {} has the wrong context or return type", expression.getExpressionType()));
                    }
                }).flatMap(expression -> this.decodeInternal(ops, context, input, expression));
            }

            @Override
            public <T> RecordBuilder<T> encode(ExpressionArgument<ENVIRONMENT, TYPE, ?> input, IScratchContextHolder<?> context, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                return this.encodeInternal(input, context, ops, prefix);
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of(ExpressionParameter.EXPRESSION_KEY, ExpressionParameter.ARGUMENTS_KEY).map(arg_0 -> ops.createString(arg_0));
            }
        };
        private final ContextualCodec<IScratchContextHolder<?>, ExpressionArgument<ENVIRONMENT, TYPE, ?>> codec = this.mapCodec.codec();
        private final ContextualStreamCodec<RegistryFriendlyByteBuf, IScratchContextHolder<?>, ExpressionArgument<ENVIRONMENT, TYPE, ?>> streamCodec = new ContextualStreamCodec<RegistryFriendlyByteBuf, IScratchContextHolder<?>, ExpressionArgument<ENVIRONMENT, TYPE, ?>>(){

            @Override
            public ExpressionArgument<ENVIRONMENT, TYPE, ?> decode(RegistryFriendlyByteBuf buffer, IScratchContextHolder<?> context) {
                try {
                    return this.decodeStreamInternal(buffer, context, (IScratchExpression)IScratchExpression.STREAM_CODEC.decode((Object)buffer));
                }
                catch (ClassCastException e) {
                    throw new DecoderException("");
                }
            }

            @Override
            public void encode(RegistryFriendlyByteBuf buffer, IScratchContextHolder<?> context, ExpressionArgument<ENVIRONMENT, TYPE, ?> value) {
                this.encodeStreamInternal(buffer, context, value);
            }
        };

        private <T, ARGUMENTS extends ScratchArguments<ENVIRONMENT, ?>> RecordBuilder<T> encodeInternal(ExpressionArgument<ENVIRONMENT, TYPE, ARGUMENTS> input, IScratchContextHolder<?> context, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return null;
        }

        private <T, ARGUMENTS extends ScratchArguments<ENVIRONMENT, ?>> DataResult<ExpressionArgument<ENVIRONMENT, TYPE, ?>> decodeInternal(DynamicOps<T> ops, IScratchContextHolder<?> context, MapLike<T> input, IScratchExpression<ENVIRONMENT, TYPE, ARGUMENTS, ?> expression) {
            return expression.getParameters().argumentsCodec().parse(ops, context, input.get(ARGUMENTS_KEY)).map(arguments -> new ExpressionArgument(expression, (ScratchArguments)arguments, this));
        }

        private <ARGUMENTS extends ScratchArguments<ENVIRONMENT, ?>> ExpressionArgument<ENVIRONMENT, TYPE, ?> decodeStreamInternal(RegistryFriendlyByteBuf buffer, IScratchContextHolder<?> context, IScratchExpression<ENVIRONMENT, TYPE, ARGUMENTS, ?> expression) {
            return new ExpressionArgument<ENVIRONMENT, TYPE, ScratchArguments>(expression, (ScratchArguments)expression.getParameters().argumentsStreamCodec().decode(buffer, context), this);
        }

        private <ARGUMENTS extends ScratchArguments<ENVIRONMENT, ?>> void encodeStreamInternal(RegistryFriendlyByteBuf buffer, IScratchContextHolder<?> context, ExpressionArgument<ENVIRONMENT, TYPE, ARGUMENTS> value) {
            IScratchExpression.STREAM_CODEC.encode((Object)buffer, value.expression());
            value.expression().getParameters().argumentsStreamCodec().encode(buffer, context, value.arguments());
        }

        protected ExpressionParameter(String key, IScratchClass<TYPE, ?> scratchClass) {
            this.key = key;
            this.scratchClass = scratchClass;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public ContextualCodec<IScratchContextHolder<?>, ExpressionArgument<ENVIRONMENT, TYPE, ?>> argumentCodec() {
            return this.codec;
        }

        @Override
        public ContextualStreamCodec<RegistryFriendlyByteBuf, IScratchContextHolder<?>, ExpressionArgument<ENVIRONMENT, TYPE, ?>> argumentStreamCodec() {
            return this.streamCodec;
        }
    }
}

