/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.scratch.argument;

import com.mojang.serialization.Codec;
import com.petrolpark.core.codec.ContextualCodec;
import com.petrolpark.core.codec.ContextualStreamCodec;
import com.petrolpark.core.scratch.argument.IScratchArgument;
import com.petrolpark.core.scratch.argument.IScratchParameter;
import com.petrolpark.core.scratch.environment.IScratchEnvironment;
import com.petrolpark.core.scratch.procedure.IScratchContext;
import com.petrolpark.core.scratch.procedure.IScratchContextHolder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class LiteralArgument<TYPE>
extends Record
implements IScratchArgument<IScratchEnvironment, TYPE> {
    private final TYPE value;
    private final LiteralParameter<TYPE> parameter;

    public LiteralArgument(TYPE value, LiteralParameter<TYPE> parameter) {
        this.value = value;
        this.parameter = parameter;
    }

    @Override
    public TYPE get(IScratchEnvironment context, IScratchContext<?> scope) {
        return this.value();
    }

    public static final LiteralParameter<Integer> intLiteral(String key) {
        return new LiteralParameter<Integer>(key, (Codec<Integer>)Codec.INT, (StreamCodec<RegistryFriendlyByteBuf, Integer>)ByteBufCodecs.INT);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LiteralArgument.class, "value;parameter", "value", "parameter"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LiteralArgument.class, "value;parameter", "value", "parameter"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LiteralArgument.class, "value;parameter", "value", "parameter"}, this, o);
    }

    public TYPE value() {
        return this.value;
    }

    public LiteralParameter<TYPE> parameter() {
        return this.parameter;
    }

    public static class LiteralParameter<TYPE>
    implements IScratchParameter<IScratchEnvironment, TYPE, LiteralArgument<TYPE>> {
        private final String key;
        private final ContextualCodec<IScratchContextHolder<?>, LiteralArgument<TYPE>> codec;
        private final ContextualStreamCodec<? super RegistryFriendlyByteBuf, IScratchContextHolder<?>, LiteralArgument<TYPE>> streamCodec;

        public LiteralParameter(String key, Codec<TYPE> codec, StreamCodec<? super RegistryFriendlyByteBuf, TYPE> streamCodec) {
            this.key = key;
            this.codec = ContextualCodec.of(codec.xmap(value -> new LiteralArgument<Object>(value, this), LiteralArgument::value));
            this.streamCodec = ContextualStreamCodec.of(streamCodec.map(value -> new LiteralArgument<Object>(value, this), LiteralArgument::value));
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public ContextualCodec<IScratchContextHolder<?>, LiteralArgument<TYPE>> argumentCodec() {
            return this.codec;
        }

        @Override
        public ContextualStreamCodec<? super RegistryFriendlyByteBuf, IScratchContextHolder<?>, LiteralArgument<TYPE>> argumentStreamCodec() {
            return this.streamCodec;
        }
    }
}

