/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.scratch.procedure;

import com.petrolpark.core.codec.ContextualCodec;
import com.petrolpark.core.codec.ContextualStreamCodec;
import com.petrolpark.core.scratch.ScratchArguments;
import com.petrolpark.core.scratch.environment.IScratchEnvironment;
import com.petrolpark.core.scratch.procedure.IScratchContext;
import com.petrolpark.core.scratch.procedure.IScratchContextHolder;
import com.petrolpark.core.scratch.symbol.block.IInstantScratchBlock;
import com.petrolpark.core.scratch.symbol.block.IInstantiableScratchBlock;
import com.petrolpark.core.scratch.symbol.block.IScratchBlock;
import com.petrolpark.core.scratch.symbol.block.IScratchBlockInstance;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class ScratchProcedure<ENVIRONMENT extends IScratchEnvironment, CONTEXT extends IScratchContext<CONTEXT>>
implements IScratchContextHolder<CONTEXT> {
    protected final IScratchContextHolder<?> enclosingContextHolder;
    protected final List<Line<? super ENVIRONMENT, ?>> lines = new ArrayList();
    protected int currentLineNumber = 0;
    protected CurrentLine<? super ENVIRONMENT, ?, ?> currentLine = null;

    public ScratchProcedure(IScratchContextHolder<?> enclosingContextHolder) {
        this.enclosingContextHolder = enclosingContextHolder;
    }

    public boolean run(ENVIRONMENT environment, CONTEXT context) {
        while (this.currentLine == null || this.currentLine.run(environment)) {
            this.currentLine = null;
            if (this.currentLineNumber < 0 || this.currentLineNumber >= this.lines.size()) {
                return true;
            }
            ++this.currentLineNumber;
            this.currentLine = this.lines.get(this.currentLineNumber).run(environment, (IScratchContext<?>)context);
        }
        return false;
    }

    public void exit() {
        this.currentLineNumber = this.lines.size();
        this.currentLine = null;
    }

    @Override
    public IScratchContextHolder<?> enclosingContextHolder() {
        return this.enclosingContextHolder;
    }

    public static <ENVIRONMENT extends IScratchEnvironment, CONTEXT extends IScratchContext<CONTEXT>> ContextualCodec<IScratchContextHolder<?>, ScratchProcedure<ENVIRONMENT, CONTEXT>> codec() {
        return null;
    }

    public static <ENVIRONMENT extends IScratchEnvironment, CONTEXT extends IScratchContext<CONTEXT>> ContextualStreamCodec<? super RegistryFriendlyByteBuf, IScratchContextHolder<?>, ScratchProcedure<ENVIRONMENT, CONTEXT>> streamCodec() {
        return null;
    }

    public record CurrentLine<ENVIRONMENT extends IScratchEnvironment, ARGUMENTS extends ScratchArguments<ENVIRONMENT, ?>, INSTANCE extends IScratchBlockInstance<ENVIRONMENT>>(IInstantiableScratchBlock<ENVIRONMENT, ARGUMENTS, INSTANCE, ?> block, ARGUMENTS arguments, INSTANCE instance) {
        public CurrentLine(IInstantiableScratchBlock<ENVIRONMENT, ARGUMENTS, INSTANCE, ?> block, ARGUMENTS arguments, ENVIRONMENT environment, IScratchContext<?> context) {
            this(block, arguments, block.run(environment, context, arguments));
        }

        public boolean run(ENVIRONMENT environment) {
            return this.instance().run(environment);
        }
    }

    public record Line<ENVIRONMENT extends IScratchEnvironment, ARGUMENTS extends ScratchArguments<ENVIRONMENT, ?>>(IScratchBlock<ENVIRONMENT, ARGUMENTS, ?> block, ARGUMENTS arguments) {
        @Nullable
        public CurrentLine<ENVIRONMENT, ARGUMENTS, ?> run(ENVIRONMENT environment, IScratchContext<?> context) {
            IScratchBlock<ENVIRONMENT, ARGUMENTS, ?> iScratchBlock = this.block();
            if (iScratchBlock instanceof IInstantiableScratchBlock) {
                IInstantiableScratchBlock instantiableBlock = (IInstantiableScratchBlock)iScratchBlock;
                return new CurrentLine(instantiableBlock, this.arguments(), environment, context);
            }
            iScratchBlock = this.block();
            if (iScratchBlock instanceof IInstantScratchBlock) {
                IInstantScratchBlock instantBlock = (IInstantScratchBlock)iScratchBlock;
                instantBlock.run(environment, context, this.arguments());
            }
            return null;
        }
    }
}

