/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.wish;

import com.petrolpark.Petrolpark;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.IForcingItemAdvancedIngredient;
import com.petrolpark.core.wish.IWishableLootPoolEntryContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class AbstractWishList {
    public static final int DEFAULT_ATTEMPTS = 10;

    public abstract Collection<IAdvancedIngredient<? super ItemStack>> getWishes();

    public abstract int getWishInstanceCount(IAdvancedIngredient<? super ItemStack> var1, int var2);

    public abstract void fulfillWish(IAdvancedIngredient<? super ItemStack> var1, ItemStack var2);

    public int getAttempts() {
        return 10;
    }

    public boolean addLootTableWishedAndRandomItemsRaw(LootTable table, Consumer<ItemStack> output, LootContext context) {
        return this.addLootTableWishedAndRandomItemsRaw(table, Collections.emptyList(), this.getWishes(), true, output, context);
    }

    public boolean addLootTableWishedAndRandomItemsRaw(LootTable table, List<LootItemFunction> additionalFunctions, Collection<IAdvancedIngredient<? super ItemStack>> wishes, boolean fulfillWishes, Consumer<ItemStack> output, LootContext context) {
        List<LootItemFunction> functions = Stream.concat(table.functions.stream(), additionalFunctions.stream()).toList();
        LootContext.VisitedEntry visitedTableEntry = LootContext.createVisitedEntry((LootTable)table);
        if (context.pushVisitedElement(visitedTableEntry)) {
            boolean successful = false;
            for (LootPool pool : table.pools) {
                successful |= this.addLootPoolWishedAndRandomItems(pool, functions, wishes, fulfillWishes, output, context);
            }
            context.popVisitedElement(visitedTableEntry);
            return successful;
        }
        Petrolpark.LOGGER.warn("Infinite loop in Loot Table while trying to grant wish");
        return false;
    }

    public boolean addLootPoolWishedAndRandomItems(LootPool pool, List<LootItemFunction> additionalFunctions, Collection<IAdvancedIngredient<? super ItemStack>> wishes, boolean fulfillWishes, Consumer<ItemStack> output, LootContext context) {
        if (!pool.compositeCondition.test(context)) {
            return false;
        }
        ArrayList<ItemStack> allStacks = new ArrayList<ItemStack>();
        boolean successful = false;
        int rolls = pool.getRolls().getInt(context) + Mth.floor((float)(pool.getBonusRolls().getFloat(context) * context.getLuck()));
        for (IAdvancedIngredient<? super ItemStack> wish : wishes) {
            if (rolls <= 0) break;
            ArrayList addedStacks = new ArrayList();
            if (!this.addLootPoolWishedItem(pool, additionalFunctions, wish, addedStacks::add, context)) continue;
            successful = true;
            int fulfilledCount = this.getWishInstanceCount(wish, rolls);
            rolls -= fulfilledCount;
            for (int i = 0; i < fulfilledCount; ++i) {
                allStacks.addAll(addedStacks.stream().map(ItemStack::copy).toList());
            }
        }
        while (rolls > 0) {
            pool.addRandomItem(stack -> {
                for (LootItemFunction function : additionalFunctions) {
                    stack = (ItemStack)function.apply(stack, (Object)context);
                }
                allStacks.add((ItemStack)stack);
            }, context);
            --rolls;
        }
        for (ItemStack stack2 : allStacks) {
            for (IAdvancedIngredient<? super ItemStack> wish : wishes) {
                successful = true;
                if (!fulfillWishes || !wish.test(stack2)) continue;
                this.fulfillWish(wish, stack2);
            }
            output.accept(stack2);
        }
        return successful;
    }

    public boolean addLootPoolWishedItem(LootPool pool, List<LootItemFunction> additionalFunctions, IAdvancedIngredient<? super ItemStack> wish, Consumer<ItemStack> output, LootContext context) {
        Stream<LootItemFunction> globalFunctions = Stream.concat(pool.functions.stream(), additionalFunctions.stream());
        for (LootPoolEntryContainer entryContainer : pool.entries) {
            List<Object> functions;
            if (entryContainer instanceof IWishableLootPoolEntryContainer) {
                IWishableLootPoolEntryContainer wishableContainer = (IWishableLootPoolEntryContainer)entryContainer;
                List<ItemStack> resultantStacks = wishableContainer.getWishedItems(this, wish, globalFunctions, context);
                if (resultantStacks.isEmpty()) continue;
                resultantStacks.forEach(output);
                return true;
            }
            if (entryContainer instanceof NestedLootTable) {
                NestedLootTable lootTable = (NestedLootTable)entryContainer;
                if (!this.addLootTableWishedAndRandomItemsRaw((LootTable)lootTable.contents.map(rl -> context.getResolver().get(Registries.LOOT_TABLE, rl).map(Holder::value).orElse(LootTable.EMPTY), Function.identity()), globalFunctions.toList(), Collections.singleton(wish), false, output, context)) continue;
                return true;
            }
            if (entryContainer instanceof LootPoolSingletonContainer) {
                int attempts;
                LootPoolSingletonContainer singletonContainer = (LootPoolSingletonContainer)entryContainer;
                functions = Stream.concat(singletonContainer.functions.stream(), globalFunctions).toList();
                int n = attempts = singletonContainer instanceof LootItem ? 1 : this.getAttempts();
                while (attempts > 0) {
                    --attempts;
                    boolean successful = false;
                    ArrayList resultantStacks = new ArrayList();
                    singletonContainer.createItemStack(stack -> resultantStacks.add(this.forceFunctions((ItemStack)stack, wish, (List<LootItemFunction>)functions, context)), context);
                    for (ItemStack resultantStack : resultantStacks) {
                        if (!wish.test(resultantStack)) continue;
                        successful = true;
                        break;
                    }
                    if (!successful) continue;
                    resultantStacks.forEach(output);
                    return true;
                }
                continue;
            }
            functions = globalFunctions.toList();
            ArrayList entries = new ArrayList();
            entryContainer.expand(context, entry -> {
                if (entry.getWeight(context.getLuck()) > 0) {
                    entries.add(entry);
                }
            });
            for (LootPoolEntry entry2 : entries) {
                int attempts = this.getAttempts();
                while (attempts > 0) {
                    --attempts;
                    boolean successful = false;
                    ArrayList resultantStacks = new ArrayList();
                    entry2.createItemStack(stack -> resultantStacks.add(this.forceFunctions((ItemStack)stack, wish, (List<LootItemFunction>)functions, context)), context);
                    for (ItemStack resultantStack : resultantStacks) {
                        if (!wish.test(resultantStack)) continue;
                        successful = true;
                        break;
                    }
                    if (!successful) continue;
                    resultantStacks.forEach(output);
                    return true;
                }
            }
        }
        return false;
    }

    public ItemStack forceFunctions(ItemStack stack, IAdvancedIngredient<? super ItemStack> wish, List<LootItemFunction> functions, LootContext context) {
        if (wish instanceof IForcingItemAdvancedIngredient) {
            IForcingItemAdvancedIngredient forcingWish = (IForcingItemAdvancedIngredient)((Object)wish);
            for (LootItemFunction function : functions) {
                stack = forcingWish.forceLootItemFunction(function, context, stack).orElse((ItemStack)function.apply((Object)stack, (Object)context));
            }
            return stack;
        }
        for (LootItemFunction function : functions) {
            stack = (ItemStack)function.apply((Object)stack, (Object)context);
        }
        return stack;
    }
}

