/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.wish;

import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WishGrantedToast
implements Toast {
    private final IAdvancedIngredient<? super ItemStack> wish;
    private final List<ItemStack> stacks = new ArrayList<ItemStack>();
    private long lastChanged;
    private boolean changed;

    public WishGrantedToast(IAdvancedIngredient<? super ItemStack> wish, ItemStack stack) {
        this.wish = wish;
        this.stacks.add(stack);
    }

    public IAdvancedIngredient<? super ItemStack> getToken() {
        return this.wish;
    }

    public Toast.Visibility render(@Nonnull GuiGraphics guiGraphics, @Nonnull ToastComponent toastComponent, long timeSinceLastVisible) {
        if (this.changed) {
            this.lastChanged = timeSinceLastVisible;
            this.changed = false;
        }
        if (this.stacks.isEmpty()) {
            return Toast.Visibility.HIDE;
        }
        ItemStack stack = this.stacks.get((int)((double)timeSinceLastVisible / Math.max(1.0, 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() / (double)this.stacks.size()) % (double)this.stacks.size()));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.6f, 0.6f, 1.0f);
        guiGraphics.renderFakeItem(stack, 3, 3);
        guiGraphics.pose().popPose();
        return (double)(timeSinceLastVisible - this.lastChanged) >= 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public void addItem(ItemStack stack) {
        this.stacks.add(stack);
        this.changed = true;
    }

    public static void addOrUpdate(ToastComponent toastComponent, IAdvancedIngredient<? super ItemStack> wish, ItemStack stack) {
        WishGrantedToast toast = (WishGrantedToast)toastComponent.getToast(WishGrantedToast.class, wish);
        if (toast == null) {
            toastComponent.addToast((Toast)new WishGrantedToast(wish, stack));
        } else {
            toast.addItem(stack);
        }
    }
}

