/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin.compat.create;

import com.petrolpark.compat.create.core.recipe.firsttimelucky.FTLRecipesBehaviour;
import com.petrolpark.compat.create.core.recipe.firsttimelucky.IFTLProcessingRecipe;
import com.petrolpark.config.PetrolparkConfigs;
import com.petrolpark.core.contamination.IContamination;
import com.petrolpark.core.contamination.ItemContamination;
import com.petrolpark.core.item.decay.ItemDecay;
import com.simibubi.create.content.kinetics.crusher.AbstractCrushingRecipe;
import com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.checkerframework.common.aliasing.qual.Unique;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={CrushingWheelControllerBlockEntity.class}, remap=false)
public abstract class CrushingWheelControllerBlockEntityMixin
extends SmartBlockEntity {
    private @Unique ItemStack lastItemProcessed = ItemStack.EMPTY;
    @Shadow
    public ProcessingInventory inventory;

    public CrushingWheelControllerBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        throw new AssertionError();
    }

    @Inject(method={"addBehaviours(Ljava/util/List;)V"}, at={@At(value="RETURN")}, remap=false)
    public void inAddBehaviours(List<BlockEntityBehaviour> behaviours, CallbackInfo ci) {
        behaviours.add(new FTLRecipesBehaviour(this, rh -> rh.value() instanceof AbstractCrushingRecipe));
    }

    @Inject(method={"applyRecipe()V"}, at={@At(value="HEAD")}, remap=false)
    public void inApplyRecipeStart(CallbackInfo ci) {
        this.lastItemProcessed = this.inventory.getStackInSlot(0).copy();
    }

    @Inject(method={"applyRecipe()V"}, at={@At(value="INVOKE", target="Ljava/util/List;size()I", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=false)
    public void inApplyRecipeMiddle(CallbackInfo ci, Optional<RecipeHolder<StandardProcessingRecipe<RecipeWrapper>>> recipe, List<ItemStack> rolledResults, int rolls, int slot) {
        Recipe recipe2;
        if (slot == 0 && (recipe2 = recipe.get().value()) instanceof IFTLProcessingRecipe) {
            IFTLProcessingRecipe ftlr = (IFTLProcessingRecipe)recipe2;
            List<ItemStack> results = ftlr.rollLuckyResults(this);
            rolledResults.clear();
            rolledResults.addAll(results);
        }
    }

    @Inject(method={"applyRecipe()V"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=false)
    public void inApplyRecipeEnd(CallbackInfo ci, Optional<RecipeHolder<StandardProcessingRecipe<RecipeWrapper>>> recipe, List<ItemStack> list) {
        list.forEach(ItemDecay::startDecay);
        if (((Boolean)PetrolparkConfigs.server().createCrushingRecipesPropagateContaminants.get()).booleanValue() && this.lastItemProcessed != null) {
            IContamination<?, ?> inputContamination = ItemContamination.get(this.lastItemProcessed);
            Level level = this.getLevel();
            if (level != null) {
                list.stream().map(ItemContamination::get).forEach(c -> c.contaminateAll(inputContamination.streamAllContaminants()));
            }
        }
    }
}

