/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="petrolpark", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PetrolparkConfig {
    protected static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue shapedCraftingPropagatesContaminants;
        public final ForgeConfigSpec.BooleanValue shapelessCraftingPropagatesContaminants;
        public final ForgeConfigSpec.BooleanValue craftingTablePropagatesContaminants;
        public final ForgeConfigSpec.BooleanValue cookingPropagatesContaminants;
        public final ForgeConfigSpec.BooleanValue brewingPropagatesContaminants;
        public final ForgeConfigSpec.BooleanValue brewingWaterBottleContaminantsIgnored;
        public final ForgeConfigSpec.BooleanValue smithingPropagatesContaminants;
        public final ForgeConfigSpec.DoubleValue createFluidContaminantWeight;
        public final ForgeConfigSpec.BooleanValue createBasinRecipesPropagateContaminants;
        public final ForgeConfigSpec.BooleanValue createCrushingRecipesPropagateContaminants;
        public final ForgeConfigSpec.BooleanValue createSandingRecipesPropagateContaminants;
        public final ForgeConfigSpec.BooleanValue createCuttingRecipesPropagateContaminants;
        public final ForgeConfigSpec.BooleanValue createOtherRecipesPropagateContaminants;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Pquality world-specific Configs").push("server");
            builder.push("contamination");
            this.shapedCraftingPropagatesContaminants = builder.comment("Simple shaped Crafting Recipes will propagate the inputs' Contaminants to the outputs, regardless of what they are crafted in").worldRestart().define("shapedCraftingPropagatesContaminants", true);
            this.shapelessCraftingPropagatesContaminants = builder.comment("Simple shapeless Crafting Recipes will propagate the inputs' Contaminants to the output, regardless of what they are crafted in").worldRestart().define("shapelessCraftingPropagatesContaminants", true);
            this.craftingTablePropagatesContaminants = builder.comment(new String[]{"Recipes done in Crafting Tables and the Inventory will propagate the inputs' Contaminants to the the output", "This can include simple shaped and shapeless Crafting Recipes, as well as custom ones like crafting Firework Stars"}).worldRestart().define("craftingTablePropagatesContaminants", true);
            this.cookingPropagatesContaminants = builder.comment("Smelting, Blasting, Smoking etc. Recipes will propagate the Contaminants of the input to the output").worldRestart().define("cookingPropagatesContaminants", true);
            this.brewingPropagatesContaminants = builder.comment("Brewing will propagate the Contaminants of inputs to the resultant Potion").worldRestart().define("brewingPropagatesContaminants", true);
            this.brewingWaterBottleContaminantsIgnored = builder.comment("The Contaminants of a Potion brewed from a Water Bottle depend only on the Contaminants of the added ingredient, not the Water Bottle").worldRestart().define("brewingWaterBottleContaminantsIgnored", true);
            this.smithingPropagatesContaminants = builder.comment("Smithing will propagate the Contaminants of the base Item and added Item to the result").worldRestart().define("smithingPropagatesContaminants", true);
            builder.pop();
            builder.push("compat");
            builder.push("create");
            this.createFluidContaminantWeight = builder.comment(new String[]{"How many mB of Fluid should be considered to be equal to one Item when weighting preserved Contaminants in any Recipes involving Fluids", "Set to 0 to not count the contaminants of fluids. Contaminants will still propagate to resultant Fluids."}).worldRestart().defineInRange("fluidContaminantWeight", 100.0, 0.0, Double.MAX_VALUE);
            this.createBasinRecipesPropagateContaminants = builder.comment("Recipes done in a Basin will propagate the Contaminants of the input to the outputs").worldRestart().define("basinRecipesPropagateContaminants", true);
            this.createCrushingRecipesPropagateContaminants = builder.comment("Recipes done by Millstones and Crushing Wheels will propagate the Contaminants of the input to the outputs").worldRestart().define("crushingRecipesPropagateContaminants", true);
            this.createSandingRecipesPropagateContaminants = builder.comment("Manual Sandpaper Polishing Recipes will propagate the Contaminants of the input to the output").worldRestart().define("sandingRecipesPropagateContaminants", true);
            this.createCuttingRecipesPropagateContaminants = builder.comment("Cutting Recipes will propagate the Contaminants of the input to the output").worldRestart().define("cuttingRecipesPropagateContaminants", true);
            this.createOtherRecipesPropagateContaminants = builder.comment("Pressing, Deploying, Washing and all Mechanical Fan Recipes propagate the Contaminants of the input to the outputs").worldRestart().define("otherRecipesPropagateContaminants", true);
            builder.pop();
            builder.pop();
        }
    }
}

