/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.client.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.RequiresCreate;
import com.petrolpark.mixin.compat.create.accessor.client.OutlineParamsAccessor;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.render.PonderRenderTypes;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

@RequiresCreate
public class CuboidOutline
extends Outline {
    protected final Vector3f start = new Vector3f(0.0f, 0.0f, 0.0f);
    protected final Vector3f end = new Vector3f(0.0f, 0.0f, 0.0f);

    public CuboidOutline set(AABB box) {
        this.start.set(box.f_82288_, box.f_82289_, box.f_82290_);
        this.end.set(box.f_82291_, box.f_82292_, box.f_82293_);
        return this;
    }

    public CuboidOutline set(Vector3f start, Vector3f end) {
        this.start.set(start.x, start.y, start.z);
        this.end.set(end.x, end.y, end.z);
        return this;
    }

    public CuboidOutline set(Vec3 start, Vec3 end) {
        this.start.set(start.f_82479_, start.f_82480_, start.f_82481_);
        this.end.set(end.f_82479_, end.f_82480_, end.f_82481_);
        return this;
    }

    public void render(PoseStack poseStack, SuperRenderTypeBuffer buffer, Vec3 camera, float pt) {
        VertexConsumer consumer = buffer.m_6299_(PonderRenderTypes.outlineSolid());
        this.params.loadColor(this.colorTemp);
        Vector4f color = this.colorTemp;
        int lightmap = ((OutlineParamsAccessor)this.params).getLightmap();
        boolean disableLineNormals = ((OutlineParamsAccessor)this.params).getDisableLineNormals();
        this.diffPosTemp.set(this.end.x - this.start.x, this.end.y - this.start.y, this.end.z - this.start.z);
        poseStack.m_85836_();
        TransformStack.of((PoseStack)poseStack).translate((double)this.start.x - camera.f_82479_, (double)this.start.y - camera.f_82480_, (double)this.start.z - camera.f_82481_);
        this.maxPosTemp.set(this.end.x - this.start.x, this.end.y - this.start.y, this.end.z - this.start.z);
        this.bufferCuboid(poseStack.m_85850_(), consumer, this.minPosTemp, this.maxPosTemp, color, lightmap, disableLineNormals);
        poseStack.m_85849_();
    }
}

