/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkTags;
import com.petrolpark.compat.create.block.entity.behaviour.ContaminationBehaviour;
import com.petrolpark.contamination.ItemContamination;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ContaminatedKineticBlockLootModifier
extends LootModifier {
    public static final Codec<ContaminatedKineticBlockLootModifier> CODEC = RecordCodecBuilder.create(inst -> ContaminatedKineticBlockLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ContaminatedKineticBlockLootModifier::new));

    public ContaminatedKineticBlockLootModifier() {
        this(new LootItemCondition[0]);
    }

    protected ContaminatedKineticBlockLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        KineticBlockEntity kbe;
        BlockEntity be = (BlockEntity)context.m_78953_(LootContextParams.f_81462_);
        if (be == null || !(be instanceof KineticBlockEntity) || !PetrolparkTags.BlockEntityTypes.CONTAMINABLE_KINETIC.matches((BlockEntity)(kbe = (KineticBlockEntity)be))) {
            return generatedLoot;
        }
        ContaminationBehaviour behaviour = (ContaminationBehaviour)kbe.getBehaviour(ContaminationBehaviour.TYPE);
        if (behaviour == null) {
            return generatedLoot;
        }
        generatedLoot.stream().filter(stack -> stack.m_41720_() == kbe.m_58900_().m_60734_().m_5456_()).map(ItemContamination::get).forEach(c -> c.contaminateAll(behaviour.getContamination().streamAllContaminants()));
        return generatedLoot;
    }
}

