/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.jei.category.builder;

import com.petrolpark.Petrolpark;
import com.petrolpark.compat.jei.category.ITickableCategory;
import com.petrolpark.compat.jei.category.PetrolparkRecipeCategory;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class PetrolparkCategoryBuilder<R extends Recipe<?>, C extends PetrolparkCategoryBuilder<R, C>> {
    public static IJeiHelpers helpers;
    protected final String modid;
    protected final Consumer<CreateRecipeCategory<?>> categoryAdder;
    protected final Class<? extends R> recipeClass;
    protected IDrawable background;
    protected IDrawable icon;
    protected final List<Consumer<List<R>>> recipeListConsumers = new ArrayList<Consumer<List<R>>>();
    protected final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();
    protected Predicate<CRecipes> createConfigPredicate;

    public PetrolparkCategoryBuilder(String modid, Class<? extends R> recipeClass, Consumer<CreateRecipeCategory<?>> categoryAdder) {
        this.modid = modid;
        this.categoryAdder = categoryAdder;
        this.recipeClass = recipeClass;
        this.createConfigPredicate = c -> true;
    }

    private final C self() {
        return (C)this;
    }

    public C addRecipes(Supplier<Collection<? extends R>> collection) {
        this.recipeListConsumers.add(recipes -> recipes.addAll((Collection)collection.get()));
        Petrolpark.LOGGER.info("Loaded " + collection.get().size() + " recipes of type " + this.recipeClass.getSimpleName() + ".");
        return this.self();
    }

    public C addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
        this.recipeListConsumers.add(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)recipeTypeEntry.getType()));
        return this.self();
    }

    public C addTypedRecipesIf(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends R>> recipeType, Predicate<Recipe<?>> pred) {
        this.recipeListConsumers.add(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
            if (pred.test((Recipe<?>)recipe)) {
                recipes.add(recipe);
            }
        }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        return this.self();
    }

    public <R2 extends Recipe<?>> C addTypedRecipesIf(Supplier<net.minecraft.world.item.crafting.RecipeType<R2>> recipeType, Function<R2, ? extends R> recipeTransformer, Predicate<R2> pred) {
        this.recipeListConsumers.add(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
            if (pred.test(recipe)) {
                recipes.add((Recipe)recipeTransformer.apply(recipe));
            }
        }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        return this.self();
    }

    public C catalysts(Collection<Supplier<ItemStack>> catalystStackSuppliers) {
        this.catalysts.addAll(catalystStackSuppliers);
        return this.self();
    }

    public C catalyst(Supplier<ItemLike> itemSupplier) {
        this.catalysts.add(() -> new ItemStack((ItemLike)((ItemLike)itemSupplier.get()).m_5456_()));
        return this.self();
    }

    public C itemIcon(ItemLike item) {
        return this.itemIcon(() -> new ItemStack(item));
    }

    public C itemIcon(Supplier<ItemStack> item) {
        this.icon = new ItemIcon(item);
        return this.self();
    }

    public C doubleItemIcon(ItemLike bigItem, ItemLike smallItem) {
        return this.doubleItemIcon(() -> new ItemStack(bigItem), () -> new ItemStack(smallItem));
    }

    public C doubleItemIcon(Supplier<ItemStack> bigItem, Supplier<ItemStack> smallItem) {
        this.icon = new DoubleItemIcon(bigItem, smallItem);
        return this.self();
    }

    public C emptyBackground(int width, int height) {
        this.background = new EmptyBackground(width, height);
        return this.self();
    }

    public C enableIfCreateConfig(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
        this.createConfigPredicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
        return this.self();
    }

    public CreateRecipeCategory<R> build(String name, PetrolparkRecipeCategory.Factory<R> factory) {
        Supplier<List> recipesSupplier = this.createConfigPredicate.test(AllConfigs.server().recipes) ? () -> {
            ArrayList recipes = new ArrayList();
            for (Consumer<List<R>> consumer : this.recipeListConsumers) {
                consumer.accept(recipes);
            }
            return recipes;
        } : () -> Collections.emptyList();
        RecipeType type = new RecipeType(new ResourceLocation(this.modid, name), this.recipeClass);
        CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(type, (Component)Component.m_237115_((String)(this.modid + ".recipe." + name)), this.background, this.icon, recipesSupplier, this.catalysts);
        CreateRecipeCategory<R> category = factory.create(info, helpers);
        this.finalizeBuilding(type, category, this.recipeClass);
        this.categoryAdder.accept(category);
        if (category instanceof ITickableCategory) {
            ITickableCategory tickableCategory = (ITickableCategory)category;
            ITickableCategory.TICKING_CATEGORIES.add(tickableCategory);
        }
        return category;
    }

    protected void finalizeBuilding(RecipeType<R> type, CreateRecipeCategory<R> category, Class<? extends R> trueClass) {
    }
}

