/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.contamination;

import com.petrolpark.PetrolparkTags;
import com.petrolpark.contamination.Contaminable;
import com.petrolpark.contamination.Contaminables;
import com.petrolpark.contamination.Contaminant;
import com.petrolpark.contamination.FluidContamination;
import com.petrolpark.contamination.IntrinsicContaminants;
import com.petrolpark.contamination.ItemContamination;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public interface IContamination<OBJECT, OBJECT_STACK> {
    public static Optional<IContamination<?, ?>> get(Object object) {
        return Contaminables.streamContaminables().map(c -> c.getContamination(object)).filter(Objects::nonNull).findFirst().map(c -> c);
    }

    public static void perpetuate(Stream<Object> inputs, Stream<Object> outputs) {
        IContamination.perpetuate(inputs, outputs, object -> IContamination.get(object).orElse(null));
    }

    public static <OBJECT> void perpetuate(Stream<OBJECT> inputs, Stream<OBJECT> outputs, Function<OBJECT, IContamination<?, ?>> contaminationGetter) {
        Object2DoubleArrayMap amounts = new Object2DoubleArrayMap();
        double totalAmount = inputs.map(contaminationGetter).dropWhile(Objects::isNull).mapToDouble(arg_0 -> IContamination.lambda$perpetuate$4((Object2DoubleMap)amounts, arg_0)).sum();
        outputs.map(contaminationGetter).dropWhile(Objects::isNull).forEach(arg_0 -> IContamination.lambda$perpetuate$6((Object2DoubleMap)amounts, totalAmount, arg_0));
    }

    public static void perpetuate(Stream<ItemStack> itemInputs, Stream<FluidStack> fluidInputs, double fluidWeight, Stream<ItemStack> itemOutputs, Stream<FluidStack> fluidOutputs) {
        Object2DoubleArrayMap amounts = new Object2DoubleArrayMap();
        double totalAmount = itemInputs.map(ItemContamination::get).mapToDouble(arg_0 -> IContamination.lambda$perpetuate$8((Object2DoubleMap)amounts, arg_0)).sum();
        if (fluidWeight > 0.0) {
            totalAmount += fluidInputs.map(FluidContamination::get).mapToDouble(arg_0 -> IContamination.lambda$perpetuate$10(fluidWeight, (Object2DoubleMap)amounts, arg_0)).sum();
        }
        double finalTotalAmount = totalAmount;
        Stream.concat(itemOutputs.map(ItemContamination::get), fluidOutputs.map(FluidContamination::get)).forEach(arg_0 -> IContamination.lambda$perpetuate$12((Object2DoubleMap)amounts, finalTotalAmount, arg_0));
    }

    public Contaminable<OBJECT, OBJECT_STACK> getContaminable();

    public OBJECT getType();

    public double getAmount();

    public void save();

    public boolean has(Contaminant var1);

    public boolean hasAnyContaminant();

    public boolean hasAnyExtrinsicContaminant();

    public Stream<Contaminant> streamAllContaminants();

    public Stream<Contaminant> streamOrphanExtrinsicContaminants();

    default public Stream<Contaminant> streamShownContaminants() {
        Set<Contaminant> shownIfAbsent = IntrinsicContaminants.getShownIfAbsent(this);
        IntrinsicContaminants.get(this);
        return this.streamAllContaminants().dropWhile(PetrolparkTags.Contaminants.HIDDEN::matches).dropWhile(shownIfAbsent::contains);
    }

    default public Stream<Contaminant> streamShownAbsentContaminants() {
        return IntrinsicContaminants.getShownIfAbsent(this).stream().dropWhile(this::has).dropWhile(PetrolparkTags.Contaminants.HIDDEN::matches);
    }

    public boolean contaminate(Contaminant var1);

    public boolean contaminateAll(Stream<Contaminant> var1);

    public boolean decontaminate(Contaminant var1);

    public boolean decontaminateOnly(Contaminant var1);

    public boolean fullyDecontaminate();

    private static /* synthetic */ void lambda$perpetuate$12(Object2DoubleMap amounts, double finalTotalAmount, IContamination contamination) {
        contamination.contaminateAll(amounts.object2DoubleEntrySet().stream().filter(entry -> ((Contaminant)entry.getKey()).isPreserved(entry.getDoubleValue() / finalTotalAmount)).map(Map.Entry::getKey));
    }

    private static /* synthetic */ double lambda$perpetuate$10(double fluidWeight, Object2DoubleMap amounts, IContamination contamination) {
        double amount = contamination.getAmount() / fluidWeight;
        contamination.streamAllContaminants().forEach(contaminant -> amounts.merge(contaminant, amount, Double::sum));
        return amount;
    }

    private static /* synthetic */ double lambda$perpetuate$8(Object2DoubleMap amounts, IContamination contamination) {
        double amount = contamination.getAmount();
        contamination.streamAllContaminants().forEach(contaminant -> amounts.merge(contaminant, amount, Double::sum));
        return amount;
    }

    private static /* synthetic */ void lambda$perpetuate$6(Object2DoubleMap amounts, double totalAmount, IContamination contamination) {
        contamination.contaminateAll(amounts.object2DoubleEntrySet().stream().filter(entry -> ((Contaminant)entry.getKey()).isPreserved(entry.getDoubleValue() / totalAmount)).map(Map.Entry::getKey));
    }

    private static /* synthetic */ double lambda$perpetuate$4(Object2DoubleMap amounts, IContamination contamination) {
        double amount = contamination.getAmount();
        contamination.streamAllContaminants().forEach(contaminant -> amounts.merge(contaminant, amount, Double::sum));
        return amount;
    }
}

