/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data.loot.numberprovider;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.petrolpark.data.IEntityTarget;
import com.petrolpark.data.loot.PetrolparkGson;
import com.petrolpark.data.loot.PetrolparkLootNumberProviderTypes;
import com.petrolpark.data.loot.numberprovider.entity.EntityNumberProvider;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ContextEntityNumberProvider
implements NumberProvider {
    public final IEntityTarget target;
    public final EntityNumberProvider entityNumberProvider;

    public ContextEntityNumberProvider(IEntityTarget target, EntityNumberProvider value) {
        this.target = target;
        this.entityNumberProvider = value;
    }

    public float m_142688_(LootContext context) {
        Entity entity = this.target.get(context);
        if (entity != null) {
            return this.entityNumberProvider.getFloat(entity, context);
        }
        return 0.0f;
    }

    public LootNumberProviderType m_142587_() {
        return (LootNumberProviderType)PetrolparkLootNumberProviderTypes.CONTEXT_ENTITY.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return Sets.union((Set)this.entityNumberProvider.m_6231_(), Set.of(this.target.getReferencedParam()));
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ContextEntityNumberProvider> {
        public void serialize(JsonObject json, ContextEntityNumberProvider value, JsonSerializationContext serializationContext) {
            json.addProperty("target", value.target.name());
            json.add("value", PetrolparkGson.get().toJsonTree((Object)value.entityNumberProvider));
        }

        public ContextEntityNumberProvider deserialize(JsonObject json, JsonDeserializationContext deserializationContext) {
            IEntityTarget entityTarget = IEntityTarget.getByName(GsonHelper.m_13906_((JsonObject)json, (String)"target"));
            EntityNumberProvider entityNumberProvider = (EntityNumberProvider)PetrolparkGson.get().fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"value"), EntityNumberProvider.class);
            return new ContextEntityNumberProvider(entityTarget, entityNumberProvider);
        }
    }
}

