/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data.loot.numberprovider;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.petrolpark.data.loot.PetrolparkLootNumberProviderTypes;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SigmoidNumberProvider
implements NumberProvider {
    public final NumberProvider shallowness;
    public final NumberProvider midpoint;
    public final NumberProvider value;

    public SigmoidNumberProvider(NumberProvider k, NumberProvider midpoint, NumberProvider x) {
        this.shallowness = k;
        this.midpoint = midpoint;
        this.value = x;
    }

    public float m_142688_(LootContext lootContext) {
        float shallowness = this.shallowness.m_142688_(lootContext);
        if (shallowness == 0.0f) {
            return 1.0f;
        }
        return 1.0f / (1.0f + (float)Math.exp((this.midpoint.m_142688_(lootContext) - this.value.m_142688_(lootContext)) / shallowness));
    }

    public LootNumberProviderType m_142587_() {
        return (LootNumberProviderType)PetrolparkLootNumberProviderTypes.SIGMOID.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return Sets.union((Set)this.shallowness.m_6231_(), (Set)this.midpoint.m_6231_());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<SigmoidNumberProvider> {
        public SigmoidNumberProvider deserialize(JsonObject json, JsonDeserializationContext deserializationContext) {
            NumberProvider k = (NumberProvider)GsonHelper.m_13836_((JsonObject)json, (String)"shallowness", (JsonDeserializationContext)deserializationContext, NumberProvider.class);
            NumberProvider midpoint = (NumberProvider)GsonHelper.m_13836_((JsonObject)json, (String)"midpoint", (JsonDeserializationContext)deserializationContext, NumberProvider.class);
            NumberProvider value = (NumberProvider)GsonHelper.m_13836_((JsonObject)json, (String)"value", (JsonDeserializationContext)deserializationContext, NumberProvider.class);
            return new SigmoidNumberProvider(k, midpoint, value);
        }

        public void serialize(JsonObject json, SigmoidNumberProvider value, JsonSerializationContext serializationContext) {
            json.add("shallowness", serializationContext.serialize((Object)value.shallowness));
            json.add("midpoint", serializationContext.serialize((Object)value.midpoint));
            json.add("value", serializationContext.serialize((Object)value.value));
        }
    }
}

