/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data.reward.generator;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.petrolpark.Petrolpark;
import com.petrolpark.data.IEntityTarget;
import com.petrolpark.data.reward.GiveItemReward;
import com.petrolpark.data.reward.IReward;
import com.petrolpark.data.reward.RewardGeneratorTypes;
import com.petrolpark.data.reward.generator.ContextEntityRewardGenerator;
import com.petrolpark.data.reward.generator.RewardGeneratorType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootTable;

public class LootTableRewardGenerator
extends ContextEntityRewardGenerator {
    public final ResourceLocation lootTableRL;

    public LootTableRewardGenerator(IEntityTarget target, ResourceLocation rl) {
        super(target);
        this.lootTableRL = rl;
    }

    @Override
    public List<IReward> generate(LootContext context) {
        ArrayList<IReward> rewards = new ArrayList<IReward>();
        LootTable table = context.m_278643_().m_278676_(this.lootTableRL);
        if (table.equals(LootTable.f_79105_) && this.lootTableRL.equals((Object)LootDataManager.f_278474_.f_278500_())) {
            Petrolpark.LOGGER.warn("Unknown Loot Table in Reward Generator: " + this.lootTableRL);
        }
        table.m_79148_(context, stack -> rewards.add(new GiveItemReward(this.target, (ItemStack)stack)));
        return rewards;
    }

    @Override
    public RewardGeneratorType getType() {
        return (RewardGeneratorType)((Object)RewardGeneratorTypes.LOOT_TABLE.get());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LootTableRewardGenerator> {
        public void serialize(JsonObject json, LootTableRewardGenerator value, JsonSerializationContext serializationContext) {
            json.addProperty("target", value.target.name());
            json.addProperty("lootTable", value.lootTableRL.toString());
        }

        public LootTableRewardGenerator deserialize(JsonObject json, JsonDeserializationContext serializationContext) {
            return new LootTableRewardGenerator(IEntityTarget.getByName(GsonHelper.m_13906_((JsonObject)json, (String)"target")), new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"lootTable")));
        }
    }
}

