/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.item.decay.recipe;

import com.petrolpark.Petrolpark;
import com.petrolpark.item.decay.IDecayingItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;

public interface IDecayingItemCookingRecipe<R extends AbstractCookingRecipe>
extends Recipe<Container> {
    public RecipeSerializer<R> getWrappedSerializer();

    public R getAsWrappedRecipe();

    public static ItemStack withDecay(ItemStack stack) {
        if (!Petrolpark.DECAYING_ITEM_HANDLER.get().isClientSide()) {
            ItemStack copy = stack.m_41777_();
            IDecayingItem.startDecay(copy);
            return copy;
        }
        return stack;
    }

    public static class DecayingItemSmokingRecipe
    extends SmokingRecipe
    implements IDecayingItemCookingRecipe<SmokingRecipe> {
        public DecayingItemSmokingRecipe(AbstractCookingRecipe recipe) {
            super(recipe.m_6423_(), recipe.m_6076_(), recipe.m_245534_(), (Ingredient)recipe.m_7527_().get(0), recipe.m_8043_(null), recipe.m_43750_(), recipe.m_43753_());
        }

        public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
            return IDecayingItemCookingRecipe.withDecay(super.m_5874_(container, registryAccess));
        }

        public ItemStack m_8043_(RegistryAccess registryAccess) {
            return IDecayingItemCookingRecipe.withDecay(super.m_8043_(registryAccess));
        }

        @Override
        public RecipeSerializer<SmokingRecipe> getWrappedSerializer() {
            return RecipeSerializer.f_44093_;
        }

        @Override
        public SmokingRecipe getAsWrappedRecipe() {
            return this;
        }
    }

    public static class DecayingItemBlastingRecipe
    extends BlastingRecipe
    implements IDecayingItemCookingRecipe<BlastingRecipe> {
        public DecayingItemBlastingRecipe(AbstractCookingRecipe recipe) {
            super(recipe.m_6423_(), recipe.m_6076_(), recipe.m_245534_(), (Ingredient)recipe.m_7527_().get(0), recipe.m_8043_(null), recipe.m_43750_(), recipe.m_43753_());
        }

        public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
            return IDecayingItemCookingRecipe.withDecay(super.m_5874_(container, registryAccess));
        }

        public ItemStack m_8043_(RegistryAccess registryAccess) {
            return IDecayingItemCookingRecipe.withDecay(super.m_8043_(registryAccess));
        }

        @Override
        public RecipeSerializer<BlastingRecipe> getWrappedSerializer() {
            return RecipeSerializer.f_44092_;
        }

        @Override
        public BlastingRecipe getAsWrappedRecipe() {
            return this;
        }
    }

    public static class DecayingItemSmeltingRecipe
    extends SmeltingRecipe
    implements IDecayingItemCookingRecipe<SmeltingRecipe> {
        public DecayingItemSmeltingRecipe(AbstractCookingRecipe recipe) {
            super(recipe.m_6423_(), recipe.m_6076_(), recipe.m_245534_(), (Ingredient)recipe.m_7527_().get(0), recipe.m_8043_(null), recipe.m_43750_(), recipe.m_43753_());
        }

        public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
            return IDecayingItemCookingRecipe.withDecay(super.m_5874_(container, registryAccess));
        }

        public ItemStack m_8043_(RegistryAccess registryAccess) {
            return IDecayingItemCookingRecipe.withDecay(super.m_8043_(registryAccess));
        }

        @Override
        public RecipeSerializer<SmeltingRecipe> getWrappedSerializer() {
            return RecipeSerializer.f_44091_;
        }

        @Override
        public SmeltingRecipe getAsWrappedRecipe() {
            return this;
        }
    }
}

