/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.recipe.ingredient;

import com.petrolpark.PetrolparkRegistries;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public interface BlockIngredient<T extends BlockIngredient<T>> {
    public static final ImpossibleBlockIngredient IMPOSSIBLE = new ImpossibleBlockIngredient();

    public BlockIngredientType<T> getType();

    public boolean isValid(BlockState var1);

    public NonNullList<ItemStack> getDisplayedItemStacks();

    public void write(FriendlyByteBuf var1);

    public static void registerType(BlockIngredientType<?> type) {
        Registry.TYPES.put(type.getId(), type);
    }

    public static void write(BlockIngredient<?> ingredient, FriendlyByteBuf buffer) {
        ResourceLocation typeId = ingredient.getType().getId();
        if (!Registry.TYPES.containsKey(typeId)) {
            throw new IllegalStateException("Block Ingredient Type " + typeId + " is not registered.");
        }
        buffer.m_130085_(typeId);
        ingredient.write(buffer);
    }

    public static BlockIngredient<?> read(FriendlyByteBuf buffer) {
        return Registry.TYPES.get(buffer.m_130281_()).read(buffer);
    }

    public static class Registry {
        private static Map<ResourceLocation, BlockIngredientType<?>> TYPES = new HashMap();

        static {
            BlockIngredient.registerType(ImpossibleBlockIngredient.TYPE);
            BlockIngredient.registerType(SingleBlockIngredient.TYPE);
            BlockIngredient.registerType(BlockTagIngredient.TYPE);
            BlockIngredient.registerType(UnionBlockIngredient.TYPE);
            BlockIngredient.registerType(IntersectionBlockIngredient.TYPE);
        }
    }

    public static interface BlockIngredientType<T extends BlockIngredient<T>> {
        public T read(FriendlyByteBuf var1);

        public ResourceLocation getId();
    }

    public static class ImpossibleBlockIngredient
    implements BlockIngredient<ImpossibleBlockIngredient> {
        public static final Type TYPE = new Type();

        @Override
        public BlockIngredientType<ImpossibleBlockIngredient> getType() {
            return TYPE;
        }

        @Override
        public boolean isValid(BlockState state) {
            return false;
        }

        @Override
        public NonNullList<ItemStack> getDisplayedItemStacks() {
            return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[0]);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
        }

        protected static class Type
        implements BlockIngredientType<ImpossibleBlockIngredient> {
            public static final ResourceLocation ID = new ResourceLocation("petrolpark", "impossible");

            protected Type() {
            }

            @Override
            public ImpossibleBlockIngredient read(FriendlyByteBuf buffer) {
                return IMPOSSIBLE;
            }

            @Override
            public ResourceLocation getId() {
                return ID;
            }
        }
    }

    public static class IntersectionBlockIngredient
    extends SetBlockIngredient<IntersectionBlockIngredient> {
        public static final Type TYPE = new Type();

        public IntersectionBlockIngredient(BlockIngredient<?>[] values) {
            super(values);
        }

        @Override
        public BlockIngredientType<IntersectionBlockIngredient> getType() {
            return TYPE;
        }

        @Override
        public boolean isValid(BlockState state) {
            return Stream.of(this.values).allMatch(i -> i.isValid(state));
        }

        @Override
        public NonNullList<ItemStack> getDisplayedItemStacks() {
            if (this.values.length == 0) {
                return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[0]);
            }
            Optional<BlockIngredient> ingredient = Stream.of(this.values).filter(i -> !i.getDisplayedItemStacks().isEmpty()).findFirst();
            if (ingredient.isEmpty()) {
                return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[0]);
            }
            return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((ItemStack[])ingredient.get().getDisplayedItemStacks().stream().filter(stack -> Stream.of(this.values).allMatch(i -> i.getDisplayedItemStacks().isEmpty() || i.getDisplayedItemStacks().contains(stack))).toArray(ItemStack[]::new)));
        }

        protected static class Type
        extends SetBlockIngredient.SetBlockIngredientType<IntersectionBlockIngredient> {
            public static final ResourceLocation ID = new ResourceLocation("petrolpark", "intersection");

            protected Type() {
            }

            @Override
            public ResourceLocation getId() {
                return ID;
            }

            @Override
            protected IntersectionBlockIngredient create(BlockIngredient<?>[] values) {
                return new IntersectionBlockIngredient(values);
            }
        }
    }

    public static class UnionBlockIngredient
    extends SetBlockIngredient<UnionBlockIngredient> {
        public static final Type TYPE = new Type();

        public UnionBlockIngredient(BlockIngredient<?>[] values) {
            super(values);
        }

        @Override
        public BlockIngredientType<UnionBlockIngredient> getType() {
            return TYPE;
        }

        @Override
        public boolean isValid(BlockState state) {
            return Stream.of(this.values).anyMatch(i -> i.isValid(state));
        }

        @Override
        public NonNullList<ItemStack> getDisplayedItemStacks() {
            HashSet<ItemStack> items = new HashSet<ItemStack>();
            for (BlockIngredient i : this.values) {
                items.addAll((Collection<ItemStack>)i.getDisplayedItemStacks());
            }
            return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((ItemStack[])items.toArray(ItemStack[]::new)));
        }

        protected static class Type
        extends SetBlockIngredient.SetBlockIngredientType<UnionBlockIngredient> {
            public static final ResourceLocation ID = new ResourceLocation("petrolpark", "union");

            protected Type() {
            }

            @Override
            public ResourceLocation getId() {
                return ID;
            }

            @Override
            protected UnionBlockIngredient create(BlockIngredient<?>[] values) {
                return new UnionBlockIngredient(values);
            }
        }
    }

    public static abstract class SetBlockIngredient<T extends BlockIngredient<T>>
    implements BlockIngredient<T> {
        public final BlockIngredient<?>[] values;

        public SetBlockIngredient(BlockIngredient<?>[] values) {
            this.values = values;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130130_(this.values.length);
            for (BlockIngredient<?> i : this.values) {
                i.write(buffer);
            }
        }

        protected static abstract class SetBlockIngredientType<T extends BlockIngredient<T>>
        implements BlockIngredientType<T> {
            protected SetBlockIngredientType() {
            }

            @Override
            public T read(FriendlyByteBuf buffer) {
                int length = buffer.m_130242_();
                BlockIngredient[] values = new BlockIngredient[length];
                for (int i = 0; i < length; ++i) {
                    values[i] = BlockIngredient.read(buffer);
                }
                return this.create(values);
            }

            protected abstract T create(BlockIngredient<?>[] var1);
        }
    }

    public static class BlockTagIngredient
    implements BlockIngredient<BlockTagIngredient> {
        public static final Type TYPE = new Type();
        public final TagKey<Block> tag;

        public BlockTagIngredient(TagKey<Block> tag) {
            this.tag = tag;
        }

        @Override
        public BlockIngredientType<BlockTagIngredient> getType() {
            return TYPE;
        }

        @Override
        public boolean isValid(BlockState state) {
            return state.m_204336_(this.tag);
        }

        @Override
        public NonNullList<ItemStack> getDisplayedItemStacks() {
            return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((ItemStack[])ForgeRegistries.BLOCKS.tags().getTag(this.tag).stream().map(block -> new ItemStack((ItemLike)block.m_5456_())).toArray(ItemStack[]::new)));
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130085_(this.tag.f_203868_());
        }

        protected static class Type
        implements BlockIngredientType<BlockTagIngredient> {
            public static final ResourceLocation ID = new ResourceLocation("petrolpark", "block_tag");

            protected Type() {
            }

            @Override
            public BlockTagIngredient read(FriendlyByteBuf buffer) {
                return new BlockTagIngredient((TagKey<Block>)BlockTags.create((ResourceLocation)buffer.m_130281_()));
            }

            @Override
            public ResourceLocation getId() {
                return ID;
            }
        }
    }

    public static class SingleBlockIngredient
    implements BlockIngredient<SingleBlockIngredient> {
        public static final Type TYPE = new Type();
        public final Block block;

        public SingleBlockIngredient(Block block) {
            this.block = block;
        }

        @Override
        public BlockIngredientType<SingleBlockIngredient> getType() {
            return TYPE;
        }

        @Override
        public boolean isValid(BlockState state) {
            return state.m_60713_(this.block);
        }

        @Override
        public NonNullList<ItemStack> getDisplayedItemStacks() {
            return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{new ItemStack((ItemLike)this.block.m_5456_())});
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            ResourceLocation rl = PetrolparkRegistries.getRegistry(Registries.f_256747_).getKey((Object)this.block);
            if (rl == null) {
                throw new IllegalArgumentException(String.format("Block %s does not exist", this.block.m_49954_().getString()));
            }
            buffer.m_130085_(rl);
        }

        protected static class Type
        implements BlockIngredientType<SingleBlockIngredient> {
            protected Type() {
            }

            @Override
            public SingleBlockIngredient read(FriendlyByteBuf buffer) {
                return new SingleBlockIngredient((Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_()));
            }

            @Override
            public ResourceLocation getId() {
                return new ResourceLocation("petrolpark", "single_block");
            }
        }
    }
}

