/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.shop.customer;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.shop.Shop;
import com.petrolpark.shop.customer.ICustomer;
import com.petrolpark.shop.offer.ShopOffer;
import com.petrolpark.util.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraftforge.common.util.INBTSerializable;
import org.slf4j.Logger;

public abstract class AbstractCustomer
implements ICustomer,
INBTSerializable<CompoundTag> {
    public int orderTime = -1;
    protected int elapsedOrderTime = 0;
    protected ShopOffer openOffer = null;
    protected Shop shop = null;

    @Override
    public int getOrderTime() {
        return this.orderTime;
    }

    @Override
    public int getElapsedOrderTime() {
        return this.elapsedOrderTime;
    }

    @Override
    public ShopOffer getOpenOffer() {
        return this.openOffer;
    }

    @Override
    public Shop getShop() {
        return this.shop;
    }

    @Override
    public void clearOpenOffer() {
        this.orderTime = -1;
        this.elapsedOrderTime = 0;
        this.openOffer = null;
        this.shop = null;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.getOrderTime() != -1) {
            tag.m_128405_("OrderTime", this.orderTime);
            if (this.elapsedOrderTime > 0) {
                tag.m_128405_("Elapsed", this.elapsedOrderTime);
            }
        }
        if (this.openOffer != null) {
            ShopOffer.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.openOffer).resultOrPartial(arg_0 -> ((Logger)Petrolpark.LOGGER).warn(arg_0)).ifPresent(t -> tag.m_128365_("Offer", t));
        }
        if (this.getShop() != null) {
            NBTHelper.writeDataRegistryObject(tag, "Shop", PetrolparkRegistries.Keys.SHOP, this.getShop());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.orderTime = -1;
        if (nbt.m_128425_("OrderTime", 3)) {
            this.orderTime = nbt.m_128451_("OrderTime");
            if (nbt.m_128425_("Elapsed", 3)) {
                this.elapsedOrderTime = nbt.m_128451_("Elapsed");
            }
        }
        if (nbt.m_128425_("Offer", 10)) {
            ShopOffer.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("Offer")).resultOrPartial(arg_0 -> ((Logger)Petrolpark.LOGGER).warn(arg_0)).map(Pair::getFirst).ifPresent(s -> {
                this.openOffer = s;
            });
        }
        if (nbt.m_128425_("Shop", 8)) {
            this.shop = NBTHelper.readDataRegistryObject(nbt, "Shop", PetrolparkRegistries.Keys.SHOP);
        }
    }

    public void tick() {
        if (this.elapsedOrderTime < this.orderTime && this.orderTime != -1) {
            ++this.elapsedOrderTime;
        }
    }
}

