package com.petrolpark.config;

import java.util.EnumMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.Supplier;

import org.apache.commons.lang3.tuple.Pair;

import net.createmod.catnip.config.ConfigBase;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(bus = EventBusSubscriber.Bus.MOD)
public class PetrolparkConfigs {
    
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<>(ModConfig.Type.class);

	private static PetrolparkClientConfig client;
	private static PetrolparkCommonConfig common;
	private static PetrolparkServerConfig server;

	public static PetrolparkClientConfig client() {
		return client;
	};

	public static PetrolparkCommonConfig common() {
		return common;
	};

	public static PetrolparkServerConfig server() {
		return server;
	};

	public static ConfigBase byType(ModConfig.Type type) {
		return CONFIGS.get(type);
	};

	private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
		Pair<T, ModConfigSpec> specPair = new ModConfigSpec.Builder().configure(builder -> {
			T config = factory.get();
			config.registerAll(builder);
			return config;
		});

		T config = specPair.getLeft();
		config.specification = specPair.getRight();
		CONFIGS.put(side, config);
		return config;
	};

	public static void register(ModLoadingContext context, ModContainer container) {
		client = register(PetrolparkClientConfig::new, ModConfig.Type.CLIENT);
		common = register(PetrolparkCommonConfig::new, ModConfig.Type.COMMON);
		server = register(PetrolparkServerConfig::new, ModConfig.Type.SERVER);

		for (Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) container.registerConfig(pair.getKey(), pair.getValue().specification);

		// CStress stress = server().kinetics.stressValues;
		// BlockStressValues.IMPACTS.registerProvider(stress::getImpact);
		// BlockStressValues.CAPACITIES.registerProvider(stress::getCapacity);
	};

	@SubscribeEvent
	public static void onLoad(ModConfigEvent.Loading event) {
		for (ConfigBase config : CONFIGS.values()) if (config.specification == event.getConfig().getSpec()) config.onLoad();
	};

	@SubscribeEvent
	public static void onReload(ModConfigEvent.Reloading event) {
		for (ConfigBase config : CONFIGS.values()) if (config.specification == event.getConfig().getSpec()) config.onReload();
	};
};
