/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.processing.basinlid;

import com.mojang.serialization.MapCodec;
import com.petrolpark.compat.create.CreateBlockEntityTypes;
import com.petrolpark.compat.create.common.processing.basinlid.BasinLidBlockEntity;
import com.petrolpark.compat.create.core.CreateShapes;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasinLidBlock
extends HorizontalDirectionalBlock
implements IBE<BasinLidBlockEntity>,
ProperWaterloggedBlock {
    public static final MapCodec<BasinLidBlock> CODEC = BasinLidBlock.simpleCodec(BasinLidBlock::new);
    public static final VoxelShaper SHAPE = CreateShapes.shape(1.0, 0.0, 1.0, 15.0, 2.0, 15.0).add(0.0, 2.0, 5.5, 15.5, 16.0, 10.5).forHorizontal(Direction.NORTH);

    public BasinLidBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING});
        super.createBlockStateDefinition(builder);
    }

    protected void onPlace(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        this.getBlockEntityOptional((BlockGetter)level, pos).ifPresent(be -> be.basinChecker.scheduleUpdate());
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return this.withWater((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection()), context);
    }

    protected BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE.get((Direction)state.getValue((Property)FACING));
    }

    protected FluidState getFluidState(@Nonnull BlockState state) {
        return this.fluidState(state);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public Class<BasinLidBlockEntity> getBlockEntityClass() {
        return BasinLidBlockEntity.class;
    }

    public BlockEntityType<? extends BasinLidBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CreateBlockEntityTypes.BASIN_LID.get();
    }

    protected boolean isPathfindable(@Nonnull BlockState state, @Nonnull PathComputationType pathComputationType) {
        return false;
    }
}

