/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.item;

import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.PetrolparkItemAttributeTypes;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.core.contamination.IContamination;
import com.petrolpark.core.contamination.ItemContamination;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@RequiresCreate
public record HasContaminantItemAttribute(Holder<Contaminant> contaminantHolder) implements ItemAttribute
{
    public static final MapCodec<HasContaminantItemAttribute> CODEC = Contaminant.CODEC.xmap(HasContaminantItemAttribute::new, HasContaminantItemAttribute::contaminantHolder).fieldOf("value");
    public static final StreamCodec<RegistryFriendlyByteBuf, HasContaminantItemAttribute> STREAM_CODEC = CatnipStreamCodecBuilders.nullable((StreamCodec)ByteBufCodecs.holderRegistry(PetrolparkRegistries.Keys.CONTAMINANT)).map(HasContaminantItemAttribute::new, HasContaminantItemAttribute::contaminantHolder);

    public boolean appliesTo(ItemStack stack, Level world) {
        return ItemContamination.get(stack).has(this.contaminantHolder);
    }

    public ItemAttributeType getType() {
        return PetrolparkItemAttributeTypes.HAS_CONTAMINANT;
    }

    public String getTranslationKey() {
        return "has_contaminant";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{Contaminant.getName(this.contaminantHolder)};
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new HasContaminantItemAttribute(null);
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            IContamination<?, ?> contamination = ItemContamination.get(stack);
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>(contamination.streamAllContaminants().map(HasContaminantItemAttribute::new).map(ItemAttribute.class::cast).toList());
            return list;
        }

        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

