/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkTags;
import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.core.block.entity.behaviour.ContaminationBehaviour;
import com.petrolpark.core.contamination.ItemContamination;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

@RequiresCreate
public class ContaminatedKineticBlockLootModifier
extends LootModifier {
    public static final MapCodec<ContaminatedKineticBlockLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> ContaminatedKineticBlockLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ContaminatedKineticBlockLootModifier::new));

    public ContaminatedKineticBlockLootModifier() {
        this(new LootItemCondition[0]);
    }

    protected ContaminatedKineticBlockLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@Nonnull ObjectArrayList<ItemStack> generatedLoot, @Nonnull LootContext context) {
        KineticBlockEntity kbe;
        BlockEntity be = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (be == null || !(be instanceof KineticBlockEntity) || !PetrolparkTags.BlockEntityTypes.CONTAMINABLE_KINETIC.matches((BlockEntity)(kbe = (KineticBlockEntity)be))) {
            return generatedLoot;
        }
        ContaminationBehaviour behaviour = (ContaminationBehaviour)kbe.getBehaviour(ContaminationBehaviour.TYPE);
        if (behaviour == null) {
            return generatedLoot;
        }
        generatedLoot.stream().filter(stack -> stack.getItem() == kbe.getBlockState().getBlock().asItem()).map(ItemContamination::get).forEach(c -> c.contaminateAll(behaviour.getContamination().streamAllContaminants()));
        return generatedLoot;
    }
}

