/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.recipe;

import com.petrolpark.core.recipe.book.IRecipeBookProviderBlock;
import com.petrolpark.util.Pair;
import java.util.Set;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;

public class RecipeBookProviderHighlighter {
    @SubscribeEvent
    public final void onTick(ClientTickEvent.Pre event) {
        IRecipeBookProviderBlock rbpBlock;
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        LocalPlayer player = mc.player;
        if (player == null || world == null) {
            return;
        }
        HitResult target = mc.hitResult;
        if (target == null || !(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult bhr = (BlockHitResult)target;
        BlockPos pos = bhr.getBlockPos();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof IRecipeBookProviderBlock && (rbpBlock = (IRecipeBookProviderBlock)block).shouldHighlightConnectedRecipeBookAcceptors((Level)world, pos, state)) {
            Set<Pair<BlockPos, IRecipeBookProviderBlock.ProvisionType>> provisions = rbpBlock.getRecipeBookProvisions((Level)world, pos, state);
            Outliner.getInstance().showCluster((Object)"recipe book acceptors", provisions.stream().filter(pair -> pair.getSecond() == IRecipeBookProviderBlock.ProvisionType.PROVIDES).map(Pair::getFirst).toList()).colored(Color.GREEN).lineWidth(0.0625f);
            Outliner.getInstance().showCluster((Object)"potential recipe book acceptors", provisions.stream().filter(pair -> pair.getSecond() == IRecipeBookProviderBlock.ProvisionType.CAN_PROVIDE).map(Pair::getFirst).toList()).colored(14532966).lineWidth(0.0625f);
        }
    }
}

