/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.tube;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.compat.create.core.tube.TubeBehaviour;
import com.petrolpark.compat.create.core.tube.TubeSpline;
import com.petrolpark.util.MathsHelper;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.Arrays;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface ITubeRenderer<T extends SmartBlockEntity> {
    default public void renderTube(T be, PoseStack ms, MultiBufferSource bufferSource, int light) {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        TubeBehaviour tube = (TubeBehaviour)be.getBehaviour(TubeBehaviour.TYPE);
        if (tube == null || !tube.isController()) {
            return;
        }
        PartialModel[] segmentModels = this.getTubeSegmentModels(be);
        TubeSpline spline = tube.getSpline();
        if (spline == null) {
            return;
        }
        VertexConsumer vc = bufferSource.getBuffer(RenderType.solid());
        float[] segmentScales = new float[spline.getPoints().size()];
        Arrays.fill(segmentScales, 1.0f);
        this.modifySegmentScales(be, segmentScales, partialTicks);
        for (int i = 0; i < spline.getPoints().size() - 1; ++i) {
            float scale = segmentScales[i];
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)segmentModels[i % segmentModels.length], (BlockState)be.getBlockState()).translateBack(Vec3.atLowerCornerOf((Vec3i)be.getBlockPos()))).translate(spline.getPoints().get(i))).rotateY((float)MathsHelper.azimuth(spline.getTangents().get(i)))).rotateX((float)MathsHelper.inclination(spline.getTangents().get(i)))).scale(scale, 1.0f, scale)).light(light).renderInto(ms, vc);
        }
    }

    public PartialModel[] getTubeSegmentModels(T var1);

    default public void modifySegmentScales(T be, float[] segmentScales, float partialTicks) {
    }
}

