/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.curios.renderer;

import com.petrolpark.compat.curios.CuriosSetup;
import com.petrolpark.compat.curios.renderer.BadgeCurioRenderer;
import com.petrolpark.compat.curios.renderer.HeadwearCurioRenderer;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@OnlyIn(value=Dist.CLIENT)
public class CuriosRenderers {
    public static void register() {
        Minecraft mc = Minecraft.getInstance();
        CuriosSetup.RENDERED_ON_HEAD.forEach((item, info) -> CuriosRendererRegistry.register((Item)((Item)item.asSupplier().get()), () -> new HeadwearCurioRenderer(mc.getEntityModels().bakeLayer(CuriosRenderers.getLayer(item)), (CuriosSetup.HeadwearCurioRenderInfo)info)));
        CuriosSetup.BADGES.forEach(item -> CuriosRendererRegistry.register((Item)((Item)item.get()), () -> new BadgeCurioRenderer(mc.getEntityModels().bakeLayer(CuriosRenderers.getBadgeLayer(item)))));
    }

    public static void onLayerRegister(EntityRenderersEvent.RegisterLayerDefinitions event) {
        CuriosSetup.RENDERED_ON_HEAD.forEach((item, info) -> event.registerLayerDefinition(CuriosRenderers.getLayer(item), () -> LayerDefinition.create((MeshDefinition)HeadwearCurioRenderer.mesh(), (int)1, (int)1)));
        CuriosSetup.BADGES.forEach(item -> event.registerLayerDefinition(CuriosRenderers.getBadgeLayer(item), () -> LayerDefinition.create((MeshDefinition)BadgeCurioRenderer.mesh(), (int)1, (int)1)));
    }

    private static ModelLayerLocation getLayer(ItemBuilder<?, ?> item) {
        return new ModelLayerLocation(item.getRegistryKey().location(), "headwear");
    }

    private static ModelLayerLocation getBadgeLayer(ItemEntry<?> item) {
        return new ModelLayerLocation(item.getId(), "badge");
    }
}

