/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.petrolpark.compat.create.CreateBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.BasinCategory;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import net.minecraft.client.gui.GuiGraphics;

public class LiddedBasinCategory
extends BasinCategory {
    private final AnimatedLiddedBasin basin = new AnimatedLiddedBasin(this);
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();

    public LiddedBasinCategory(CreateRecipeCategory.Info<BasinRecipe> info, IJeiHelpers helpers) {
        super(info, true);
    }

    public void draw(@Nonnull BasinRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, graphics, mouseX, mouseY);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (requiredHeat != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, this.getBackground().getWidth() / 2 + 3, 55);
        }
        this.basin.draw(graphics, this.getBackground().getWidth() / 2 + 3, 71);
    }

    class AnimatedLiddedBasin
    extends AnimatedKinetics {
        AnimatedLiddedBasin(LiddedBasinCategory this$0) {
        }

        public void draw(@Nonnull GuiGraphics graphics, int xOffset, int yOffset) {
            PoseStack matrixStack = graphics.pose();
            matrixStack.pushPose();
            matrixStack.translate((float)xOffset, (float)yOffset, 200.0f);
            matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
            matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
            int scale = 23;
            this.blockElement(AllBlocks.BASIN.getDefaultState()).atLocal(0.0, 0.0, 0.0).scale((double)scale).render(graphics);
            this.blockElement(CreateBlocks.BASIN_LID.getDefaultState()).atLocal(0.0, -1.0, 0.0).scale((double)scale).render(graphics);
            matrixStack.popPose();
        }
    }
}

