/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider;

import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkNumberProviderTypes;
import com.petrolpark.core.data.loot.numberprovider.IEstimableNumberProvider;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import com.petrolpark.core.data.loot.numberprovider.itemstack.ItemStackNumberProvider;
import com.petrolpark.util.CodecHelper;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;

public record ContextToolNumberProvider(ItemStackNumberProvider value) implements IEstimableNumberProvider
{
    public static final MapCodec<ContextToolNumberProvider> CODEC = CodecHelper.singleFieldMap(ItemStackNumberProvider.CODEC, "value", ContextToolNumberProvider::value, ContextToolNumberProvider::new);

    public float getFloat(@Nonnull LootContext lootContext) {
        ItemStack tool = (ItemStack)lootContext.getParamOrNull(LootContextParams.TOOL);
        if (tool != null) {
            return this.value.getFloat(tool, lootContext);
        }
        return 0.0f;
    }

    @Override
    public NumberEstimate getEstimate() {
        return this.value().getEstimate();
    }

    @Override
    public float getMaxFloat(LootContext context) {
        ItemStack tool = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        if (tool != null) {
            return this.value.getMaxFloat(tool, context);
        }
        return 0.0f;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Collections.singleton(LootContextParams.TOOL);
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)PetrolparkNumberProviderTypes.CONTEXT_TOOL.get();
    }
}

