/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward.entity;

import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkRewardTypes;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import com.petrolpark.core.data.reward.entity.EntityRewardType;
import com.petrolpark.core.data.reward.entity.IPlayerReward;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record GrantExperiencePlayerReward(NumberProvider amount) implements IPlayerReward
{
    public static final MapCodec<GrantExperiencePlayerReward> CODEC = CodecHelper.singleFieldMap(NumberProviders.CODEC, "amount", GrantExperiencePlayerReward::amount, GrantExperiencePlayerReward::new);

    @Override
    public void rewardPlayer(Player player, LootContext context, float multiplier) {
        player.giveExperiencePoints(this.amount.getInt(context));
    }

    @Override
    public void render(GuiGraphics graphics) {
        throw new UnsupportedOperationException("Unimplemented method 'render'");
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder builder) {
        NumberEstimate amount = NumberEstimate.get(this.amount());
        if (amount.unknown()) {
            builder.add(this.translate("unknown_amount", new Object[0]));
        } else {
            builder.add(this.translateSimple(amount.getIntComponent()));
        }
    }

    @Override
    public EntityRewardType getType() {
        return (EntityRewardType)PetrolparkRewardTypes.GRANT_EXPERIENCE.get();
    }
}

